/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.utils;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;

public abstract class Task
extends AsyncTask<Void, Void, Void> {
    private static Handler mHandler;

    public abstract void doInBackground();

    protected Void doInBackground(Void ... params) {
        this.doInBackground();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Handler getHandler() {
        if (mHandler != null) return mHandler;
        Class<Task> clazz = Task.class;
        synchronized (Task.class) {
            if (mHandler != null) return mHandler;
            mHandler = new Handler(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return mHandler;
        }
    }

    public void executeDelayed(final Executor executor, long delayInMillis) {
        Task.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                Task.this.executeOnExecutor(executor != null ? executor : AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
            }
        }, delayInMillis);
    }

    public void execute(final Executor executor) {
        Task.getHandler().post(new Runnable(){

            @Override
            public void run() {
                Task.this.executeOnExecutor(executor != null ? executor : AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
            }
        });
    }

    public static void execute(Task task, Executor executor) {
        if (task != null) {
            task.execute(executor);
        }
    }

    public static void executeDelayed(Task task, Executor executor, long delayInMillis) {
        if (task != null) {
            task.executeDelayed(executor, delayInMillis);
        }
    }

    public static void executeDelayed(final FutureTask task, final Executor executor, long delayInMillis) {
        if (task != null && executor != null) {
            Task.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    executor.execute(task);
                }
            }, delayInMillis);
        }
    }
}

