/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.search.le;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import com.proton.bluetooth.search.BluetoothSearcher;
import com.proton.bluetooth.search.SearchResult;
import com.proton.bluetooth.search.response.BluetoothSearchResponse;
import com.proton.bluetooth.utils.BluetoothUtils;
import com.proton.bluetooth.utils.Logger;

public class BluetoothLESearcher
extends BluetoothSearcher {
    private final BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            BluetoothLESearcher.this.notifyDeviceFounded(new SearchResult(device, rssi, scanRecord));
        }
    };

    private BluetoothLESearcher() {
        this.mBluetoothAdapter = BluetoothUtils.getBluetoothAdapter();
    }

    public static BluetoothLESearcher getInstance() {
        return BluetoothLESearcherHolder.instance;
    }

    @Override
    @TargetApi(value=18)
    public void startScanBluetooth(BluetoothSearchResponse response) {
        super.startScanBluetooth(response);
        this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
    }

    @Override
    @TargetApi(value=18)
    public void stopScanBluetooth() {
        try {
            this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        }
        catch (Exception e) {
            Logger.e(e);
        }
        super.stopScanBluetooth();
    }

    @Override
    @TargetApi(value=18)
    protected void cancelScanBluetooth() {
        this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        super.cancelScanBluetooth();
    }

    private static class BluetoothLESearcherHolder {
        private static BluetoothLESearcher instance = new BluetoothLESearcher();

        private BluetoothLESearcherHolder() {
        }
    }
}

