/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.search.classic;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.proton.bluetooth.search.BluetoothSearcher;
import com.proton.bluetooth.search.SearchResult;
import com.proton.bluetooth.search.response.BluetoothSearchResponse;
import com.proton.bluetooth.utils.BluetoothUtils;

public class BluetoothClassicSearcher
extends BluetoothSearcher {
    private BluetoothSearchReceiver mReceiver;

    private BluetoothClassicSearcher() {
        this.mBluetoothAdapter = BluetoothUtils.getBluetoothAdapter();
    }

    public static BluetoothClassicSearcher getInstance() {
        return BluetoothClassicSearcherHolder.instance;
    }

    @Override
    public void startScanBluetooth(BluetoothSearchResponse callback) {
        super.startScanBluetooth(callback);
        this.registerReceiver();
        if (this.mBluetoothAdapter.isDiscovering()) {
            this.mBluetoothAdapter.cancelDiscovery();
        }
        this.mBluetoothAdapter.startDiscovery();
    }

    @Override
    public void stopScanBluetooth() {
        this.unregisterReceiver();
        if (this.mBluetoothAdapter.isDiscovering()) {
            this.mBluetoothAdapter.cancelDiscovery();
        }
        super.stopScanBluetooth();
    }

    @Override
    protected void cancelScanBluetooth() {
        this.unregisterReceiver();
        if (this.mBluetoothAdapter.isDiscovering()) {
            this.mBluetoothAdapter.cancelDiscovery();
        }
        super.cancelScanBluetooth();
    }

    private void registerReceiver() {
        if (this.mReceiver == null) {
            this.mReceiver = new BluetoothSearchReceiver();
            BluetoothUtils.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.device.action.FOUND"));
        }
    }

    private void unregisterReceiver() {
        if (this.mReceiver != null) {
            BluetoothUtils.unregisterReceiver(this.mReceiver);
            this.mReceiver = null;
        }
    }

    private class BluetoothSearchReceiver
    extends BroadcastReceiver {
        private BluetoothSearchReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.bluetooth.device.action.FOUND")) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                short rssi = intent.getShortExtra("android.bluetooth.device.extra.RSSI", (short)Short.MIN_VALUE);
                SearchResult xmDevice = new SearchResult(device, rssi, null);
                BluetoothClassicSearcher.this.notifyDeviceFounded(xmDevice);
            }
        }
    }

    private static class BluetoothClassicSearcherHolder {
        private static BluetoothClassicSearcher instance = new BluetoothClassicSearcher();

        private BluetoothClassicSearcherHolder() {
        }
    }
}

