/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.search;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.proton.bluetooth.search.BluetoothSearchTask;
import com.proton.bluetooth.search.SearchRequest;
import com.proton.bluetooth.search.SearchResult;
import com.proton.bluetooth.search.SearchTask;
import com.proton.bluetooth.search.response.BluetoothSearchResponse;
import com.proton.bluetooth.utils.BluetoothUtils;
import com.proton.bluetooth.utils.Logger;
import java.util.ArrayList;
import java.util.List;

public class BluetoothSearchRequest
implements Handler.Callback {
    private static final int SCAN_INTERVAL = 100;
    private static final int MSG_START_SEARCH = 17;
    private static final int MSG_DEVICE_FOUND = 18;
    private List<BluetoothSearchTask> mSearchTaskList = new ArrayList<BluetoothSearchTask>();
    private BluetoothSearchResponse mSearchResponse;
    private BluetoothSearchTask mCurrentTask;
    private Handler mHandler;

    public BluetoothSearchRequest(SearchRequest request) {
        List<SearchTask> tasks = request.getTasks();
        for (SearchTask task : tasks) {
            this.mSearchTaskList.add(new BluetoothSearchTask(task));
        }
        this.mHandler = new Handler(Looper.myLooper(), (Handler.Callback)this);
    }

    public void setSearchResponse(BluetoothSearchResponse response) {
        this.mSearchResponse = response;
    }

    public void start() {
        if (this.mSearchResponse != null) {
            this.mSearchResponse.onSearchStarted();
        }
        this.notifyConnectedBluetoothDevices();
        this.mHandler.sendEmptyMessageDelayed(17, 100L);
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 17: {
                this.scheduleNewSearchTask();
                break;
            }
            case 18: {
                SearchResult device = (SearchResult)msg.obj;
                if (this.mSearchResponse == null) break;
                this.mSearchResponse.onDeviceFounded(device);
            }
        }
        return true;
    }

    private void scheduleNewSearchTask() {
        if (this.mSearchTaskList.size() > 0) {
            this.mCurrentTask = this.mSearchTaskList.remove(0);
            this.mCurrentTask.start(new BluetoothSearchTaskResponse(this.mCurrentTask));
        } else {
            this.mCurrentTask = null;
            if (this.mSearchResponse != null) {
                this.mSearchResponse.onSearchStopped();
            }
        }
    }

    public void cancel() {
        if (this.mCurrentTask != null) {
            this.mCurrentTask.cancel();
            this.mCurrentTask = null;
        }
        this.mSearchTaskList.clear();
        if (this.mSearchResponse != null) {
            this.mSearchResponse.onSearchCanceled();
        }
        this.mSearchResponse = null;
    }

    private void notifyConnectedBluetoothDevices() {
        boolean hasBleTask = false;
        boolean hasBscTask = false;
        for (BluetoothSearchTask task : this.mSearchTaskList) {
            if (task.isBluetoothLeSearch()) {
                hasBleTask = true;
                continue;
            }
            if (task.isBluetoothClassicSearch()) {
                hasBscTask = true;
                continue;
            }
            throw new IllegalArgumentException("unknown search task type!");
        }
        if (hasBleTask) {
            this.notifyConnectedBluetoothLeDevices();
        }
        if (hasBscTask) {
            this.notifyBondedBluetoothClassicDevices();
        }
    }

    private void notifyConnectedBluetoothLeDevices() {
        List<BluetoothDevice> devices = BluetoothUtils.getConnectedBluetoothLeDevices();
        for (BluetoothDevice device : devices) {
            this.notifyDeviceFounded(new SearchResult(device));
        }
    }

    private void notifyBondedBluetoothClassicDevices() {
        List<BluetoothDevice> devices = BluetoothUtils.getBondedBluetoothClassicDevices();
        for (BluetoothDevice device : devices) {
            this.notifyDeviceFounded(new SearchResult(device));
        }
    }

    private void notifyDeviceFounded(SearchResult device) {
        this.mHandler.obtainMessage(18, (Object)device).sendToTarget();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (BluetoothSearchTask task : this.mSearchTaskList) {
            sb.append(task.toString() + ", ");
        }
        return sb.toString();
    }

    private class BluetoothSearchTaskResponse
    implements BluetoothSearchResponse {
        BluetoothSearchTask task;

        BluetoothSearchTaskResponse(BluetoothSearchTask task) {
            this.task = task;
        }

        @Override
        public void onSearchStarted() {
            Logger.v(String.format("%s onSearchStarted", this.task));
        }

        @Override
        public void onDeviceFounded(SearchResult device) {
            Logger.v(String.format("onDeviceFounded %s", device));
            BluetoothSearchRequest.this.notifyDeviceFounded(device);
        }

        @Override
        public void onSearchStopped() {
            Logger.v(String.format("%s onSearchStopped", this.task));
            BluetoothSearchRequest.this.mHandler.sendEmptyMessageDelayed(17, 100L);
        }

        @Override
        public void onSearchCanceled() {
            Logger.v(String.format("%s onSearchCanceled", this.task));
        }
    }
}

