/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.search;

import android.os.Bundle;
import android.os.Parcelable;
import com.proton.bluetooth.connect.response.BleGeneralResponse;
import com.proton.bluetooth.search.BluetoothSearchHelper;
import com.proton.bluetooth.search.BluetoothSearchRequest;
import com.proton.bluetooth.search.SearchRequest;
import com.proton.bluetooth.search.SearchResult;
import com.proton.bluetooth.search.response.BluetoothSearchResponse;

public class BluetoothSearchManager {
    public static void search(SearchRequest request, final BleGeneralResponse response) {
        BluetoothSearchRequest requestWrapper = new BluetoothSearchRequest(request);
        BluetoothSearchHelper.getInstance().startSearch(requestWrapper, new BluetoothSearchResponse(){

            @Override
            public void onSearchStarted() {
                response.onResponse(1, null);
            }

            @Override
            public void onDeviceFounded(SearchResult device) {
                Bundle bundle = new Bundle();
                bundle.putParcelable("extra.search.result", (Parcelable)device);
                response.onResponse(4, bundle);
            }

            @Override
            public void onSearchStopped() {
                response.onResponse(2, null);
            }

            @Override
            public void onSearchCanceled() {
                response.onResponse(3, null);
            }
        });
    }

    public static void stopSearch() {
        BluetoothSearchHelper.getInstance().stopSearch();
    }
}

