/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.search;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.proton.bluetooth.search.BluetoothSearchRequest;
import com.proton.bluetooth.search.IBluetoothSearchHelper;
import com.proton.bluetooth.search.SearchResult;
import com.proton.bluetooth.search.response.BluetoothSearchResponse;
import com.proton.bluetooth.utils.BluetoothUtils;
import com.proton.bluetooth.utils.proxy.ProxyBulk;
import com.proton.bluetooth.utils.proxy.ProxyInterceptor;
import com.proton.bluetooth.utils.proxy.ProxyUtils;
import java.lang.reflect.Method;

public class BluetoothSearchHelper
implements IBluetoothSearchHelper,
ProxyInterceptor,
Handler.Callback {
    private BluetoothSearchRequest mCurrentRequest;
    private static IBluetoothSearchHelper sInstance;
    private Handler mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);

    private BluetoothSearchHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBluetoothSearchHelper getInstance() {
        if (sInstance != null) return sInstance;
        Class<BluetoothSearchHelper> clazz = BluetoothSearchHelper.class;
        synchronized (BluetoothSearchHelper.class) {
            if (sInstance != null) return sInstance;
            BluetoothSearchHelper helper = new BluetoothSearchHelper();
            sInstance = (IBluetoothSearchHelper)ProxyUtils.getProxy(helper, IBluetoothSearchHelper.class, helper);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public void startSearch(BluetoothSearchRequest request, BluetoothSearchResponse response) {
        request.setSearchResponse(new BluetoothSearchResponseImpl(response));
        if (!BluetoothUtils.isBluetoothEnabled()) {
            request.cancel();
        } else {
            this.stopSearch();
            if (this.mCurrentRequest == null) {
                this.mCurrentRequest = request;
                this.mCurrentRequest.start();
            }
        }
    }

    @Override
    public void stopSearch() {
        if (this.mCurrentRequest != null) {
            this.mCurrentRequest.cancel();
            this.mCurrentRequest = null;
        }
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] args) {
        this.mHandler.obtainMessage(0, (Object)new ProxyBulk(object, method, args)).sendToTarget();
        return true;
    }

    public boolean handleMessage(Message msg) {
        ProxyBulk.safeInvoke(msg.obj);
        return true;
    }

    private class BluetoothSearchResponseImpl
    implements BluetoothSearchResponse {
        BluetoothSearchResponse response;

        BluetoothSearchResponseImpl(BluetoothSearchResponse response) {
            this.response = response;
        }

        @Override
        public void onSearchStarted() {
            this.response.onSearchStarted();
        }

        @Override
        public void onDeviceFounded(SearchResult device) {
            this.response.onDeviceFounded(device);
        }

        @Override
        public void onSearchStopped() {
            this.response.onSearchStopped();
            BluetoothSearchHelper.this.mCurrentRequest = null;
        }

        @Override
        public void onSearchCanceled() {
            this.response.onSearchCanceled();
            BluetoothSearchHelper.this.mCurrentRequest = null;
        }
    }
}

