/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.receiver;

import android.content.Context;
import android.content.Intent;
import com.proton.bluetooth.receiver.AbsBluetoothReceiver;
import com.proton.bluetooth.receiver.IReceiverDispatcher;
import com.proton.bluetooth.receiver.listener.BluetoothReceiverListener;
import com.proton.bluetooth.receiver.listener.BluetoothStateChangeListener;
import com.proton.bluetooth.utils.Logger;
import java.util.Arrays;
import java.util.List;

public class BluetoothStateReceiver
extends AbsBluetoothReceiver {
    private static final String[] ACTIONS = new String[]{"android.bluetooth.adapter.action.STATE_CHANGED"};

    protected BluetoothStateReceiver(IReceiverDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    List<String> getActions() {
        return Arrays.asList(ACTIONS);
    }

    public static BluetoothStateReceiver newInstance(IReceiverDispatcher dispatcher) {
        return new BluetoothStateReceiver(dispatcher);
    }

    @Override
    public boolean onReceive(Context context, Intent intent) {
        int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
        int previousState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", 0);
        Logger.v(String.format("state changed: %s -> %s", this.getStateString(previousState), this.getStateString(state)));
        this.onBluetoothStateChanged(previousState, state);
        return true;
    }

    private void onBluetoothStateChanged(int previousState, int state) {
        List<BluetoothReceiverListener> listeners = this.getListeners(BluetoothStateChangeListener.class);
        for (BluetoothReceiverListener listener : listeners) {
            listener.invoke(previousState, state);
        }
    }

    private String getStateString(int state) {
        switch (state) {
            case 12: {
                return "state_on";
            }
            case 10: {
                return "state_off";
            }
            case 13: {
                return "state_turning_off";
            }
            case 11: {
                return "state_turning_on";
            }
        }
        return "unknown";
    }
}

