/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.receiver;

import android.content.Context;
import android.content.Intent;
import com.proton.bluetooth.receiver.AbsBluetoothReceiver;
import com.proton.bluetooth.receiver.IReceiverDispatcher;
import com.proton.bluetooth.receiver.listener.BleConnectStatusChangeListener;
import com.proton.bluetooth.receiver.listener.BluetoothReceiverListener;
import com.proton.bluetooth.utils.Logger;
import java.util.Arrays;
import java.util.List;

public class BleConnectStatusChangeReceiver
extends AbsBluetoothReceiver {
    private static final String[] ACTIONS = new String[]{"action.connect_status_changed"};

    protected BleConnectStatusChangeReceiver(IReceiverDispatcher dispatcher) {
        super(dispatcher);
    }

    public static BleConnectStatusChangeReceiver newInstance(IReceiverDispatcher dispatcher) {
        return new BleConnectStatusChangeReceiver(dispatcher);
    }

    @Override
    List<String> getActions() {
        return Arrays.asList(ACTIONS);
    }

    @Override
    boolean onReceive(Context context, Intent intent) {
        String mac = intent.getStringExtra("extra.mac");
        int status = intent.getIntExtra("extra.status", 0);
        Logger.v(String.format("onConnectStatusChanged for %s, status = %d", mac, status));
        this.onConnectStatusChanged(mac, status);
        return true;
    }

    private void onConnectStatusChanged(String mac, int status) {
        List<BluetoothReceiverListener> listeners = this.getListeners(BleConnectStatusChangeListener.class);
        for (BluetoothReceiverListener listener : listeners) {
            listener.invoke(mac, status);
        }
    }
}

