/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.connect;

import android.os.HandlerThread;
import android.os.Looper;
import com.proton.bluetooth.connect.BleConnectMaster;
import com.proton.bluetooth.connect.IBleConnectMaster;
import com.proton.bluetooth.connect.options.BleConnectOptions;
import com.proton.bluetooth.connect.response.BleGeneralResponse;
import java.util.HashMap;
import java.util.UUID;

public class BleConnectManager {
    private static final String TAG = BleConnectManager.class.getSimpleName();
    private static HashMap<String, IBleConnectMaster> mBleConnectMasters = new HashMap();
    private static HandlerThread mWorkerThread;

    private static Looper getWorkerLooper() {
        if (mWorkerThread == null) {
            mWorkerThread = new HandlerThread(TAG);
            mWorkerThread.start();
        }
        return mWorkerThread.getLooper();
    }

    private static IBleConnectMaster getBleConnectMaster(String mac) {
        IBleConnectMaster master = mBleConnectMasters.get(mac);
        if (master == null) {
            master = BleConnectMaster.newInstance(mac, BleConnectManager.getWorkerLooper());
            mBleConnectMasters.put(mac, master);
        }
        return master;
    }

    public static void connect(String mac, BleConnectOptions options, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).connect(options, response);
    }

    public static void disconnect(String mac) {
        BleConnectManager.getBleConnectMaster(mac).disconnect();
    }

    public static void read(String mac, UUID service, UUID character, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).read(service, character, response);
    }

    public static void write(String mac, UUID service, UUID character, byte[] value, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).write(service, character, value, response);
    }

    public static void writeNoRsp(String mac, UUID service, UUID character, byte[] value, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).writeNoRsp(service, character, value, response);
    }

    public static void readDescriptor(String mac, UUID service, UUID character, UUID descriptor, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).readDescriptor(service, character, descriptor, response);
    }

    public static void writeDescriptor(String mac, UUID service, UUID character, UUID descriptor, byte[] value, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).writeDescriptor(service, character, descriptor, value, response);
    }

    public static void notify(String mac, UUID service, UUID character, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).notify(service, character, response);
    }

    public static void unnotify(String mac, UUID service, UUID character, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).unnotify(service, character, response);
    }

    public static void readRssi(String mac, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).readRssi(response);
    }

    public static void indicate(String mac, UUID service, UUID character, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).indicate(service, character, response);
    }

    public static void requestMtu(String mac, int mtu, BleGeneralResponse response) {
        BleConnectManager.getBleConnectMaster(mac).requestMtu(mtu, response);
    }

    public static void clearRequest(String mac, int type) {
        BleConnectManager.getBleConnectMaster(mac).clearRequest(type);
    }

    public static void refreshCache(String mac) {
        BleConnectManager.getBleConnectMaster(mac).refreshCache();
    }
}

