/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import com.proton.bluetooth.BluetoothContext;
import com.proton.bluetooth.BluetoothService;
import com.proton.bluetooth.BluetoothServiceImpl;
import com.proton.bluetooth.IBluetoothClient;
import com.proton.bluetooth.IBluetoothService;
import com.proton.bluetooth.connect.listener.BleConnectStatusListener;
import com.proton.bluetooth.connect.listener.BluetoothStateListener;
import com.proton.bluetooth.connect.options.BleConnectOptions;
import com.proton.bluetooth.connect.response.BleConnectResponse;
import com.proton.bluetooth.connect.response.BleMtuResponse;
import com.proton.bluetooth.connect.response.BleNotifyResponse;
import com.proton.bluetooth.connect.response.BleReadResponse;
import com.proton.bluetooth.connect.response.BleReadRssiResponse;
import com.proton.bluetooth.connect.response.BleUnnotifyResponse;
import com.proton.bluetooth.connect.response.BleWriteResponse;
import com.proton.bluetooth.connect.response.BluetoothResponse;
import com.proton.bluetooth.model.BleGattProfile;
import com.proton.bluetooth.receiver.BluetoothReceiver;
import com.proton.bluetooth.receiver.listener.BleCharacterChangeListener;
import com.proton.bluetooth.receiver.listener.BleConnectStatusChangeListener;
import com.proton.bluetooth.receiver.listener.BluetoothBondListener;
import com.proton.bluetooth.receiver.listener.BluetoothBondStateChangeListener;
import com.proton.bluetooth.receiver.listener.BluetoothStateChangeListener;
import com.proton.bluetooth.search.SearchRequest;
import com.proton.bluetooth.search.SearchResult;
import com.proton.bluetooth.search.response.SearchResponse;
import com.proton.bluetooth.utils.ListUtils;
import com.proton.bluetooth.utils.Logger;
import com.proton.bluetooth.utils.proxy.ProxyBulk;
import com.proton.bluetooth.utils.proxy.ProxyInterceptor;
import com.proton.bluetooth.utils.proxy.ProxyUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;

public class BluetoothClientImpl
implements IBluetoothClient,
ProxyInterceptor,
Handler.Callback {
    private static final int MSG_INVOKE_PROXY = 1;
    private static final int MSG_REG_RECEIVER = 2;
    private static final String TAG = BluetoothClientImpl.class.getSimpleName();
    private Context mContext;
    private volatile IBluetoothService mBluetoothService;
    private static volatile IBluetoothClient sInstance;
    private CountDownLatch mCountDownLatch;
    private HandlerThread mWorkerThread;
    private Handler mWorkerHandler;
    private HashMap<String, HashMap<String, List<BleNotifyResponse>>> mNotifyResponses;
    private HashMap<String, List<BleConnectStatusListener>> mConnectStatusListeners;
    private List<BluetoothStateListener> mBluetoothStateListeners;
    private List<BluetoothBondListener> mBluetoothBondListeners;
    private final ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            BluetoothClientImpl.this.mBluetoothService = IBluetoothService.Stub.asInterface(service);
            BluetoothClientImpl.this.notifyBluetoothManagerReady();
        }

        public void onServiceDisconnected(ComponentName name) {
            BluetoothClientImpl.this.mBluetoothService = null;
        }
    };

    private BluetoothClientImpl(Context context) {
        this.mContext = context.getApplicationContext();
        BluetoothContext.set(this.mContext);
        this.mWorkerThread = new HandlerThread(TAG);
        this.mWorkerThread.start();
        this.mWorkerHandler = new Handler(this.mWorkerThread.getLooper(), (Handler.Callback)this);
        this.mNotifyResponses = new HashMap();
        this.mConnectStatusListeners = new HashMap();
        this.mBluetoothStateListeners = new LinkedList<BluetoothStateListener>();
        this.mBluetoothBondListeners = new LinkedList<BluetoothBondListener>();
        this.mWorkerHandler.obtainMessage(2).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBluetoothClient getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<BluetoothClientImpl> clazz = BluetoothClientImpl.class;
        synchronized (BluetoothClientImpl.class) {
            if (sInstance != null) return sInstance;
            BluetoothClientImpl client = new BluetoothClientImpl(context);
            sInstance = (IBluetoothClient)ProxyUtils.getProxy(client, IBluetoothClient.class, client);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private IBluetoothService getBluetoothService() {
        if (this.mBluetoothService == null) {
            this.bindServiceSync();
        }
        return this.mBluetoothService;
    }

    private void bindServiceSync() {
        this.checkRuntime(true);
        this.mCountDownLatch = new CountDownLatch(1);
        Intent intent = new Intent();
        intent.setClass(this.mContext, BluetoothService.class);
        if (this.mContext.bindService(intent, this.mConnection, 1)) {
            this.waitBluetoothManagerReady();
        } else {
            this.mBluetoothService = BluetoothServiceImpl.getInstance();
        }
    }

    @Override
    public void connect(String mac, BleConnectOptions options, final BleConnectResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putParcelable("extra.options", (Parcelable)options);
        this.safeCallBluetoothApi(1, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    data.setClassLoader(this.getClass().getClassLoader());
                    BleGattProfile profile = (BleGattProfile)data.getParcelable("extra.gatt.profile");
                    response.onResponse(code, profile);
                }
            }
        });
    }

    @Override
    public void disconnect(String mac) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        this.safeCallBluetoothApi(2, args, null);
        this.clearNotifyListener(mac);
    }

    @Override
    public void registerConnectStatusListener(String mac, BleConnectStatusListener listener) {
        this.checkRuntime(true);
        List<BleConnectStatusListener> listeners = this.mConnectStatusListeners.get(mac);
        if (listeners == null) {
            listeners = new ArrayList<BleConnectStatusListener>();
            this.mConnectStatusListeners.put(mac, listeners);
        }
        if (listener != null && !listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    @Override
    public void unregisterConnectStatusListener(String mac, BleConnectStatusListener listener) {
        this.checkRuntime(true);
        List<BleConnectStatusListener> listeners = this.mConnectStatusListeners.get(mac);
        if (listener != null && !ListUtils.isEmpty(listeners)) {
            listeners.remove(listener);
        }
    }

    @Override
    public void read(String mac, UUID service, UUID character, final BleReadResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putSerializable("extra.service.uuid", (Serializable)service);
        args.putSerializable("extra.character.uuid", (Serializable)character);
        this.safeCallBluetoothApi(3, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    response.onResponse(code, data.getByteArray("extra.byte.value"));
                }
            }
        });
    }

    @Override
    public void write(String mac, UUID service, UUID character, byte[] value, final BleWriteResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putSerializable("extra.service.uuid", (Serializable)service);
        args.putSerializable("extra.character.uuid", (Serializable)character);
        args.putByteArray("extra.byte.value", value);
        this.safeCallBluetoothApi(4, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    response.onResponse(code);
                }
            }
        });
    }

    @Override
    public void readDescriptor(String mac, UUID service, UUID character, UUID descriptor, final BleReadResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putSerializable("extra.service.uuid", (Serializable)service);
        args.putSerializable("extra.character.uuid", (Serializable)character);
        args.putSerializable("extra.descriptor.uuid", (Serializable)descriptor);
        this.safeCallBluetoothApi(13, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    response.onResponse(code, data.getByteArray("extra.byte.value"));
                }
            }
        });
    }

    @Override
    public void writeDescriptor(String mac, UUID service, UUID character, UUID descriptor, byte[] value, final BleWriteResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putSerializable("extra.service.uuid", (Serializable)service);
        args.putSerializable("extra.character.uuid", (Serializable)character);
        args.putSerializable("extra.descriptor.uuid", (Serializable)descriptor);
        args.putByteArray("extra.byte.value", value);
        this.safeCallBluetoothApi(14, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    response.onResponse(code);
                }
            }
        });
    }

    @Override
    public void writeNoRsp(String mac, UUID service, UUID character, byte[] value, final BleWriteResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putSerializable("extra.service.uuid", (Serializable)service);
        args.putSerializable("extra.character.uuid", (Serializable)character);
        args.putByteArray("extra.byte.value", value);
        this.safeCallBluetoothApi(5, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    response.onResponse(code);
                }
            }
        });
    }

    private void saveNotifyListener(String mac, UUID service, UUID character, BleNotifyResponse response) {
        String key;
        List<BleNotifyResponse> responses;
        this.checkRuntime(true);
        HashMap<String, List<BleNotifyResponse>> listenerMap = this.mNotifyResponses.get(mac);
        if (listenerMap == null) {
            listenerMap = new HashMap();
            this.mNotifyResponses.put(mac, listenerMap);
        }
        if ((responses = listenerMap.get(key = this.generateCharacterKey(service, character))) == null) {
            responses = new ArrayList<BleNotifyResponse>();
            listenerMap.put(key, responses);
        }
        responses.add(response);
    }

    private void removeNotifyListener(String mac, UUID service, UUID character) {
        this.checkRuntime(true);
        HashMap<String, List<BleNotifyResponse>> listenerMap = this.mNotifyResponses.get(mac);
        if (listenerMap != null) {
            String key = this.generateCharacterKey(service, character);
            listenerMap.remove(key);
        }
    }

    private void clearNotifyListener(String mac) {
        this.checkRuntime(true);
        this.mNotifyResponses.remove(mac);
    }

    private String generateCharacterKey(UUID service, UUID character) {
        return String.format("%s_%s", service, character);
    }

    @Override
    public void notify(final String mac, final UUID service, final UUID character, final BleNotifyResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putSerializable("extra.service.uuid", (Serializable)service);
        args.putSerializable("extra.character.uuid", (Serializable)character);
        this.safeCallBluetoothApi(6, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    if (code == 0) {
                        BluetoothClientImpl.this.saveNotifyListener(mac, service, character, response);
                    }
                    response.onResponse(code);
                }
            }
        });
    }

    @Override
    public void unnotify(final String mac, final UUID service, final UUID character, final BleUnnotifyResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putSerializable("extra.service.uuid", (Serializable)service);
        args.putSerializable("extra.character.uuid", (Serializable)character);
        this.safeCallBluetoothApi(7, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                BluetoothClientImpl.this.removeNotifyListener(mac, service, character);
                if (response != null) {
                    response.onResponse(code);
                }
            }
        });
    }

    @Override
    public void indicate(final String mac, final UUID service, final UUID character, final BleNotifyResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putSerializable("extra.service.uuid", (Serializable)service);
        args.putSerializable("extra.character.uuid", (Serializable)character);
        this.safeCallBluetoothApi(10, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    if (code == 0) {
                        BluetoothClientImpl.this.saveNotifyListener(mac, service, character, response);
                    }
                    response.onResponse(code);
                }
            }
        });
    }

    @Override
    public void unindicate(String mac, UUID service, UUID character, BleUnnotifyResponse response) {
        this.unnotify(mac, service, character, response);
    }

    @Override
    public void readRssi(String mac, final BleReadRssiResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        this.safeCallBluetoothApi(8, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    response.onResponse(code, data.getInt("extra.rssi", 0));
                }
            }
        });
    }

    @Override
    public void requestMtu(String mac, int mtu, final BleMtuResponse response) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putInt("extra.mtu", mtu);
        this.safeCallBluetoothApi(22, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response != null) {
                    response.onResponse(code, data.getInt("extra.mtu", 23));
                }
            }
        });
    }

    @Override
    public void search(SearchRequest request, final SearchResponse response) {
        Bundle args = new Bundle();
        args.putParcelable("extra.request", (Parcelable)request);
        this.safeCallBluetoothApi(11, args, new BluetoothResponse(){

            @Override
            protected void onAsyncResponse(int code, Bundle data) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (response == null) {
                    return;
                }
                data.setClassLoader(this.getClass().getClassLoader());
                switch (code) {
                    case 1: {
                        response.onSearchStarted();
                        break;
                    }
                    case 3: {
                        response.onSearchCanceled();
                        break;
                    }
                    case 2: {
                        response.onSearchStopped();
                        break;
                    }
                    case 4: {
                        SearchResult device = (SearchResult)data.getParcelable("extra.search.result");
                        response.onDeviceFounded(device);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown code");
                    }
                }
            }
        });
    }

    @Override
    public void stopSearch() {
        this.safeCallBluetoothApi(12, null, null);
    }

    @Override
    public void registerBluetoothStateListener(BluetoothStateListener listener) {
        this.checkRuntime(true);
        if (listener != null && !this.mBluetoothStateListeners.contains(listener)) {
            this.mBluetoothStateListeners.add(listener);
        }
    }

    @Override
    public void unregisterBluetoothStateListener(BluetoothStateListener listener) {
        this.checkRuntime(true);
        if (listener != null) {
            this.mBluetoothStateListeners.remove(listener);
        }
    }

    @Override
    public void registerBluetoothBondListener(BluetoothBondListener listener) {
        this.checkRuntime(true);
        if (listener != null && !this.mBluetoothBondListeners.contains(listener)) {
            this.mBluetoothBondListeners.add(listener);
        }
    }

    @Override
    public void unregisterBluetoothBondListener(BluetoothBondListener listener) {
        this.checkRuntime(true);
        if (listener != null) {
            this.mBluetoothBondListeners.remove(listener);
        }
    }

    @Override
    public void clearRequest(String mac, int type) {
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        args.putInt("extra.type", type);
        this.safeCallBluetoothApi(20, args, null);
    }

    @Override
    public void refreshCache(String mac) {
        this.checkRuntime(true);
        Bundle args = new Bundle();
        args.putString("extra.mac", mac);
        this.safeCallBluetoothApi(21, args, null);
    }

    private void safeCallBluetoothApi(int code, Bundle args, BluetoothResponse response) {
        this.checkRuntime(true);
        try {
            IBluetoothService service = this.getBluetoothService();
            if (service != null) {
                args = args != null ? args : new Bundle();
                service.callBluetoothApi(code, args, response);
            } else {
                response.onResponse(-6, null);
            }
        }
        catch (Throwable e) {
            Logger.e(e);
        }
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] args) {
        this.mWorkerHandler.obtainMessage(1, (Object)new ProxyBulk(object, method, args)).sendToTarget();
        return true;
    }

    private void notifyBluetoothManagerReady() {
        if (this.mCountDownLatch != null) {
            this.mCountDownLatch.countDown();
            this.mCountDownLatch = null;
        }
    }

    private void waitBluetoothManagerReady() {
        try {
            this.mCountDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                ProxyBulk.safeInvoke(msg.obj);
                break;
            }
            case 2: {
                this.registerBluetoothReceiver();
            }
        }
        return true;
    }

    private void registerBluetoothReceiver() {
        this.checkRuntime(true);
        BluetoothReceiver.getInstance().register(new BluetoothStateChangeListener(){

            @Override
            protected void onBluetoothStateChanged(int prevState, int curState) {
                BluetoothClientImpl.this.checkRuntime(true);
                BluetoothClientImpl.this.dispatchBluetoothStateChanged(curState);
            }
        });
        BluetoothReceiver.getInstance().register(new BluetoothBondStateChangeListener(){

            @Override
            protected void onBondStateChanged(String mac, int bondState) {
                BluetoothClientImpl.this.checkRuntime(true);
                BluetoothClientImpl.this.dispatchBondStateChanged(mac, bondState);
            }
        });
        BluetoothReceiver.getInstance().register(new BleConnectStatusChangeListener(){

            @Override
            protected void onConnectStatusChanged(String mac, int status) {
                BluetoothClientImpl.this.checkRuntime(true);
                if (status == 32) {
                    BluetoothClientImpl.this.clearNotifyListener(mac);
                }
                BluetoothClientImpl.this.dispatchConnectionStatus(mac, status);
            }
        });
        BluetoothReceiver.getInstance().register(new BleCharacterChangeListener(){

            @Override
            public void onCharacterChanged(String mac, UUID service, UUID character, byte[] value) {
                BluetoothClientImpl.this.checkRuntime(true);
                BluetoothClientImpl.this.dispatchCharacterNotify(mac, service, character, value);
            }
        });
    }

    private void dispatchCharacterNotify(String mac, UUID service, UUID character, byte[] value) {
        String key;
        List<BleNotifyResponse> responses;
        this.checkRuntime(true);
        HashMap<String, List<BleNotifyResponse>> notifyMap = this.mNotifyResponses.get(mac);
        if (notifyMap != null && (responses = notifyMap.get(key = this.generateCharacterKey(service, character))) != null) {
            for (BleNotifyResponse response : responses) {
                response.onNotify(service, character, value);
            }
        }
    }

    private void dispatchConnectionStatus(String mac, int status) {
        this.checkRuntime(true);
        List<BleConnectStatusListener> listeners = this.mConnectStatusListeners.get(mac);
        if (!ListUtils.isEmpty(listeners)) {
            for (BleConnectStatusListener listener : listeners) {
                listener.invokeSync(mac, status);
            }
        }
    }

    private void dispatchBluetoothStateChanged(int currentState) {
        this.checkRuntime(true);
        if (currentState == 10 || currentState == 12) {
            for (BluetoothStateListener listener : this.mBluetoothStateListeners) {
                listener.invokeSync(currentState == 12);
            }
        }
    }

    private void dispatchBondStateChanged(String mac, int bondState) {
        this.checkRuntime(true);
        for (BluetoothBondListener listener : this.mBluetoothBondListeners) {
            listener.invokeSync(mac, bondState);
        }
    }

    private void checkRuntime(boolean async) {
        Looper targetLooper;
        Looper looper = targetLooper = async ? this.mWorkerHandler.getLooper() : Looper.getMainLooper();
        if (Looper.myLooper() != targetLooper) {
            throw new RuntimeException();
        }
    }
}

