/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.utils.proxy;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.proton.bluetooth.utils.Logger;
import com.proton.bluetooth.utils.proxy.ProxyBulk;
import com.proton.bluetooth.utils.proxy.ProxyInterceptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ProxyInvocationHandler
implements InvocationHandler,
ProxyInterceptor,
Handler.Callback {
    private Object subject;
    private ProxyInterceptor interceptor;
    private boolean weakRef;
    private boolean postUI;
    private Handler handler;

    public ProxyInvocationHandler(Object subject) {
        this(subject, null);
    }

    public ProxyInvocationHandler(Object subject, ProxyInterceptor interceptor) {
        this(subject, interceptor, false);
    }

    public ProxyInvocationHandler(Object subject, ProxyInterceptor interceptor, boolean weakRef) {
        this(subject, interceptor, weakRef, false);
    }

    public ProxyInvocationHandler(Object subject, ProxyInterceptor interceptor, boolean weakRef, boolean postUI) {
        this.weakRef = weakRef;
        this.interceptor = interceptor;
        this.postUI = postUI;
        this.subject = this.getObject(subject);
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object subject = this.getObject();
        if (!this.onIntercept(subject, method, args)) {
            ProxyBulk bulk = new ProxyBulk(subject, method, args);
            return this.postUI ? this.postSafeInvoke(bulk) : this.safeInvoke(bulk);
        }
        return null;
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] args) {
        if (this.interceptor != null) {
            try {
                return this.interceptor.onIntercept(object, method, args);
            }
            catch (Exception e) {
                Logger.e(e);
            }
        }
        return false;
    }

    private Object getObject(Object object) {
        return this.weakRef ? new WeakReference<Object>(object) : object;
    }

    private Object getObject() {
        if (this.weakRef) {
            return ((WeakReference)this.subject).get();
        }
        return this.subject;
    }

    private Object postSafeInvoke(ProxyBulk bulk) {
        this.handler.obtainMessage(0, (Object)bulk).sendToTarget();
        return null;
    }

    private Object safeInvoke(ProxyBulk bulk) {
        try {
            return bulk.safeInvoke();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean handleMessage(Message msg) {
        ProxyBulk.safeInvoke(msg.obj);
        return true;
    }
}

