/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.support.annotation.NonNull;
import android.support.v4.util.SparseArrayCompat;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarPagerAdapter;
import com.prolificinteractive.materialcalendarview.DateRangeIndex;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.MonthView;

class MonthPagerAdapter
extends CalendarPagerAdapter<MonthView> {
    MonthPagerAdapter(MaterialCalendarView mcv) {
        super(mcv);
    }

    @Override
    protected MonthView createView(int position) {
        return new MonthView(this.mcv, this.getItem(position), this.mcv.getFirstDayOfWeek());
    }

    @Override
    protected int indexOf(MonthView view) {
        CalendarDay month = view.getMonth();
        return this.getRangeIndex().indexOf(month);
    }

    @Override
    protected boolean isInstanceOfView(Object object) {
        return object instanceof MonthView;
    }

    @Override
    protected DateRangeIndex createRangeIndex(CalendarDay min, CalendarDay max) {
        return new Monthly(min, max);
    }

    public static class Monthly
    implements DateRangeIndex {
        private final CalendarDay min;
        private final int count;
        private SparseArrayCompat<CalendarDay> dayCache = new SparseArrayCompat();

        public Monthly(@NonNull CalendarDay min, @NonNull CalendarDay max) {
            this.min = CalendarDay.from(min.getYear(), min.getMonth(), 1);
            max = CalendarDay.from(max.getYear(), max.getMonth(), 1);
            this.count = this.indexOf(max) + 1;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int indexOf(CalendarDay day) {
            int yDiff = day.getYear() - this.min.getYear();
            int mDiff = day.getMonth() - this.min.getMonth();
            return yDiff * 12 + mDiff;
        }

        @Override
        public CalendarDay getItem(int position) {
            CalendarDay re = (CalendarDay)this.dayCache.get(position);
            if (re != null) {
                return re;
            }
            int numY = position / 12;
            int numM = position % 12;
            int year = this.min.getYear() + numY;
            int month = this.min.getMonth() + numM;
            if (month >= 12) {
                ++year;
                month -= 12;
            }
            re = CalendarDay.from(year, month, 1);
            this.dayCache.put(position, (Object)re);
            return re;
        }
    }
}

