/*
 * Decompiled with CFR 0.152.
 */
package math.math;

import references.references.NumberReference;

public class math {
    public static double Negate(double x) {
        return -x;
    }

    public static double Positive(double x) {
        return x;
    }

    public static double Factorial(double x) {
        double f = 1.0;
        for (double i = 2.0; i <= x; i += 1.0) {
            f *= i;
        }
        return f;
    }

    public static double Round(double x) {
        return Math.floor(x + 0.5);
    }

    public static double BankersRound(double x) {
        double r = math.Absolute(x - math.Truncate(x)) == 0.5 ? (!math.DivisibleBy(math.Round(x), 2.0) ? math.Round(x) - 1.0 : math.Round(x)) : math.Round(x);
        return r;
    }

    public static double Ceil(double x) {
        return Math.ceil(x);
    }

    public static double Floor(double x) {
        return Math.floor(x);
    }

    public static double Truncate(double x) {
        double t = x >= 0.0 ? Math.floor(x) : Math.ceil(x);
        return t;
    }

    public static double Absolute(double x) {
        return Math.abs(x);
    }

    public static double Logarithm(double x) {
        return Math.log10(x);
    }

    public static double NaturalLogarithm(double x) {
        return Math.log(x);
    }

    public static double Sin(double x) {
        return Math.sin(x);
    }

    public static double Cos(double x) {
        return Math.cos(x);
    }

    public static double Tan(double x) {
        return Math.tan(x);
    }

    public static double Asin(double x) {
        return Math.asin(x);
    }

    public static double Acos(double x) {
        return Math.acos(x);
    }

    public static double Atan(double x) {
        return Math.atan(x);
    }

    public static double Atan2(double y, double x) {
        double a = 0.0;
        if (x > 0.0) {
            a = math.Atan(y / x);
        } else if (x < 0.0 && y >= 0.0) {
            a = math.Atan(y / x) + Math.PI;
        } else if (x < 0.0 && y < 0.0) {
            a = math.Atan(y / x) - Math.PI;
        } else if (x == 0.0 && y > 0.0) {
            a = 1.5707963267948966;
        } else if (x == 0.0 && y < 0.0) {
            a = -1.5707963267948966;
        }
        return a;
    }

    public static double Squareroot(double x) {
        return Math.sqrt(x);
    }

    public static double Exp(double x) {
        return Math.exp(x);
    }

    public static boolean DivisibleBy(double a, double b) {
        return a % b == 0.0;
    }

    public static double Combinations(double n, double k) {
        double c = 1.0;
        double j = 1.0;
        double i = n - k + 1.0;
        while (i <= n) {
            c *= i;
            c /= j;
            i += 1.0;
            j += 1.0;
        }
        return c;
    }

    public static double Permutations(double n, double k) {
        double c = 1.0;
        for (double i = n - k + 1.0; i <= n; i += 1.0) {
            c *= i;
        }
        return c;
    }

    public static boolean EpsilonCompare(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static double GreatestCommonDivisor(double a, double b) {
        while (b != 0.0) {
            double t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    public static double GCDWithSubtraction(double a, double b) {
        double g;
        if (a == 0.0) {
            g = b;
        } else {
            while (b != 0.0) {
                if (a > b) {
                    a -= b;
                    continue;
                }
                b -= a;
            }
            g = a;
        }
        return g;
    }

    public static boolean IsInteger(double a) {
        return a - Math.floor(a) == 0.0;
    }

    public static boolean GreatestCommonDivisorWithCheck(double a, double b, NumberReference gcdReference) {
        boolean success;
        if (math.IsInteger(a) && math.IsInteger(b)) {
            double gcd;
            gcdReference.numberValue = gcd = math.GreatestCommonDivisor(a, b);
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public static double LeastCommonMultiple(double a, double b) {
        double lcm = a > 0.0 && b > 0.0 ? Math.abs(a * b) / math.GreatestCommonDivisor(a, b) : 0.0;
        return lcm;
    }

    public static double Sign(double a) {
        double s = a > 0.0 ? 1.0 : (a < 0.0 ? -1.0 : 0.0);
        return s;
    }

    public static double Max(double a, double b) {
        return Math.max(a, b);
    }

    public static double Min(double a, double b) {
        return Math.min(a, b);
    }

    public static double Power(double a, double b) {
        return Math.pow(a, b);
    }

    public static double Gamma(double x) {
        return math.LanczosApproximation(x);
    }

    public static double LogGamma(double x) {
        return Math.log(math.Gamma(x));
    }

    public static double LanczosApproximation(double z) {
        double y;
        double[] p = new double[]{676.5203681218851, -1259.1392167224028, 771.3234287776531, -176.6150291621406, 12.507343278686905, -0.13857109526572012, 9.984369578019572E-6, 1.5056327351493116E-7};
        if (z < 0.5) {
            y = Math.PI / (Math.sin(Math.PI * z) * math.LanczosApproximation(1.0 - z));
        } else {
            z -= 1.0;
            double x = 0.9999999999998099;
            for (double i = 0.0; i < (double)p.length; i += 1.0) {
                x += p[(int)i] / (z + i + 1.0);
            }
            double t = z + (double)p.length - 0.5;
            y = Math.sqrt(Math.PI * 2) * Math.pow(t, z + 0.5) * Math.exp(-t) * x;
        }
        return y;
    }

    public static double Beta(double x, double y) {
        return math.Gamma(x) * math.Gamma(y) / math.Gamma(x + y);
    }

    public static double Sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static double Cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static double Tanh(double x) {
        return math.Sinh(x) / math.Cosh(x);
    }

    public static double Cot(double x) {
        return 1.0 / Math.tan(x);
    }

    public static double Sec(double x) {
        return 1.0 / Math.cos(x);
    }

    public static double Csc(double x) {
        return 1.0 / Math.sin(x);
    }

    public static double Coth(double x) {
        return math.Cosh(x) / math.Sinh(x);
    }

    public static double Sech(double x) {
        return 1.0 / math.Cosh(x);
    }

    public static double Csch(double x) {
        return 1.0 / math.Sinh(x);
    }

    public static double Error(double x) {
        double y;
        if (x == 0.0) {
            y = 0.0;
        } else if (x < 0.0) {
            y = -math.Error(-x);
        } else {
            double c1 = -1.26551223;
            double c2 = 1.00002368;
            double c3 = 0.37409196;
            double c4 = 0.09678418;
            double c5 = -0.18628806;
            double c6 = 0.27886807;
            double c7 = -1.13520398;
            double c8 = 1.48851587;
            double c9 = -0.82215223;
            double c10 = 0.17087277;
            double t = 1.0 / (1.0 + 0.5 * Math.abs(x));
            double tau = t * Math.exp(-Math.pow(x, 2.0) + c1 + t * (c2 + t * (c3 + t * (c4 + t * (c5 + t * (c6 + t * (c7 + t * (c8 + t * (c9 + t * c10)))))))));
            y = 1.0 - tau;
        }
        return y;
    }

    public static double ErrorInverse(double x) {
        double a = 0.1400122886866665;
        double t = 2.0 / (Math.PI * a) + Math.log(1.0 - Math.pow(x, 2.0)) / 2.0;
        double y = math.Sign(x) * Math.sqrt(Math.sqrt(Math.pow(t, 2.0) - Math.log(1.0 - Math.pow(x, 2.0)) / a) - t);
        return y;
    }

    public static double FallingFactorial(double x, double n) {
        double y = 1.0;
        for (double k = 0.0; k <= n - 1.0; k += 1.0) {
            y *= x - k;
        }
        return y;
    }

    public static double RisingFactorial(double x, double n) {
        double y = 1.0;
        for (double k = 0.0; k <= n - 1.0; k += 1.0) {
            y *= x + k;
        }
        return y;
    }

    public static double Hypergeometric(double a, double b, double c, double z, double maxIterations, double precision) {
        double y = Math.abs(z) >= 0.5 ? Math.pow(1.0 - z, -a) * math.HypergeometricDirect(a, c - b, c, z / (z - 1.0), maxIterations, precision) : math.HypergeometricDirect(a, b, c, z, maxIterations, precision);
        return y;
    }

    public static double HypergeometricDirect(double a, double b, double c, double z, double maxIterations, double precision) {
        double y = 0.0;
        boolean done = false;
        for (double n = 0.0; n < maxIterations && !done; n += 1.0) {
            double yp = math.RisingFactorial(a, n) * math.RisingFactorial(b, n) / math.RisingFactorial(c, n) * Math.pow(z, n) / math.Factorial(n);
            if (Math.abs(yp) < precision) {
                done = true;
            }
            y += yp;
        }
        return y;
    }

    public static double BernouilliNumber(double n) {
        return math.AkiyamaTanigawaAlgorithm(n);
    }

    public static double AkiyamaTanigawaAlgorithm(double n) {
        double[] A = new double[(int)(n + 1.0)];
        for (double m = 0.0; m <= n; m += 1.0) {
            A[(int)m] = 1.0 / (m + 1.0);
            for (double j = m; j >= 1.0; j -= 1.0) {
                A[(int)(j - 1.0)] = j * (A[(int)(j - 1.0)] - A[(int)j]);
            }
        }
        double B = A[0];
        math.delete(A);
        return B;
    }

    public static void delete(Object object) {
    }
}

