/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.prqa.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.praqma.prqa.parsers.Rule;

public class MessageGroup
implements Serializable {
    private String messageGroupName;
    private int totalViolations;
    private List<Rule> violatedRules = new ArrayList<Rule>();
    private int messagesWithinTreshold;

    public MessageGroup(String messageGroupName) {
        this.messageGroupName = messageGroupName;
    }

    public String getMessageGroupName() {
        return this.messageGroupName;
    }

    public int getTotalViolations() {
        if (this.totalViolations == 0) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Rule violatedRule : this.getViolatedRules()) {
                map.putAll(violatedRule.getMessages());
            }
            this.totalViolations = Rule.calc(map);
        }
        return this.totalViolations;
    }

    public List<Rule> getViolatedRules() {
        return this.violatedRules;
    }

    public void addViolatedRule(Rule rule) {
        this.violatedRules.add(rule);
    }

    public int getMessagesWithinThreshold() {
        return this.messagesWithinTreshold;
    }

    public void setMessagesWithinThreshold(int thresholdLevel, Map<String, Integer> total) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Rule violatedRule : this.getViolatedRules()) {
            int ruleID = violatedRule.getRuleNumber();
            if (ruleID < thresholdLevel || ruleID > 9) continue;
            map.putAll(violatedRule.getMessages());
            total.putAll(violatedRule.getMessages());
        }
        this.messagesWithinTreshold = Rule.calc(map);
    }
}

