/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.utils;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class PRQABuildUtils {
    public static String normalizeWithEnv(String in, AbstractBuild<?, ?> build, TaskListener listener) {
        Boolean isOsWindows;
        FilePath buildWorkspace = build.getWorkspace();
        if (buildWorkspace == null) {
            throw new RuntimeException("Invalid workspace");
        }
        try {
            isOsWindows = (Boolean)buildWorkspace.act((Callable)new MasterToSlaveCallable<Boolean, RuntimeException>(){

                public Boolean call() throws RuntimeException {
                    return SystemUtils.IS_OS_WINDOWS;
                }
            });
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace(listener.getLogger());
            return in;
        }
        String out = in;
        if (StringUtils.isEmpty((String)out)) {
            return out;
        }
        TreeMap envVars = new TreeMap();
        try {
            EnvVars environment = build.getEnvironment(listener);
            envVars.putAll(environment);
        }
        catch (IOException | InterruptedException environment) {
            // empty catch block
        }
        ArrayList<String> regexTemplate = new ArrayList<String>();
        if (isOsWindows.booleanValue()) {
            regexTemplate.add("%%%s%%");
        } else {
            regexTemplate.add("\\$\\{%s}");
            regexTemplate.add("\\$%s");
        }
        for (Map.Entry entry : envVars.entrySet()) {
            for (String regex : regexTemplate) {
                out = out.replaceAll(String.format(regex, entry.getKey()), (String)entry.getValue());
            }
        }
        return out;
    }
}

