/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.setup;

import com.google.common.base.Strings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.praqma.jenkins.plugin.prqa.setup.PRQAToolSuite;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class QAFrameworkInstallationConfiguration
extends ToolInstallation
implements PRQAToolSuite,
NodeSpecific<QAFrameworkInstallationConfiguration> {
    private static final long serialVersionUID = 1L;
    public final String qafHome;
    public final String qafName;
    public final String toolType;
    public final String tool;

    @DataBoundConstructor
    public QAFrameworkInstallationConfiguration(String qafName, String qafHome, String tool, String toolType) {
        super(qafName, qafHome, null);
        this.qafHome = qafHome;
        this.qafName = qafName;
        this.toolType = toolType;
        this.tool = tool;
    }

    @Override
    public HashMap<String, String> createEnvironmentVariables(String workspaceRoot) {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("QAFINSTALLPATH", this.getHome());
        environment.put("WORKSPACEPATH", workspaceRoot);
        return environment;
    }

    public HashMap<String, String> convert(EnvVars vars) {
        HashMap<String, String> varsMap = new HashMap<String, String>();
        for (Map.Entry s : vars.entrySet()) {
            varsMap.put((String)s.getKey(), (String)s.getValue());
        }
        return varsMap;
    }

    public static QAFrameworkInstallationConfiguration getInstallationByName(String qafName) {
        QAFrameworkInstallationConfiguration[] installations;
        if (StringUtils.isBlank((String)qafName)) {
            return null;
        }
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance == null) {
            return null;
        }
        for (QAFrameworkInstallationConfiguration install : installations = (QAFrameworkInstallationConfiguration[])((DescriptorImpl)instance.getDescriptorByType(DescriptorImpl.class)).getInstallations()) {
            if (!install.getName().equals(qafName)) continue;
            return install;
        }
        return null;
    }

    public QAFrameworkInstallationConfiguration forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        String translatedHome = this.translateFor(node, log);
        return new QAFrameworkInstallationConfiguration(this.qafName, translatedHome, this.toolType, this.tool);
    }

    @Extension
    public static final class DescriptorImpl
    extends ToolDescriptor<QAFrameworkInstallationConfiguration> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "PRQA\u00b7Framework";
        }

        public QAFrameworkInstallationConfiguration newInstance(StaplerRequest req, @Nonnull JSONObject formData) throws Descriptor.FormException {
            if (req == null) {
                throw new Descriptor.FormException((Throwable)new Exception("Bad request"), "Bad request");
            }
            QAFrameworkInstallationConfiguration suite = (QAFrameworkInstallationConfiguration)req.bindJSON(QAFrameworkInstallationConfiguration.class, formData);
            this.save();
            return suite;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            boolean configure;
            String qafHome = "qafHome";
            String qafName = "qafName";
            String tool = "tool";
            if (!json.isEmpty()) {
                ArrayList<String> qaInstallationNames = new ArrayList<String>();
                if (json.get(tool) instanceof JSONArray) {
                    JSONArray array = json.getJSONArray(tool);
                    Iterator it = array.iterator();
                    while (it.hasNext()) {
                        JSONObject jsonObject = (JSONObject)it.next();
                        String qaName = jsonObject.getString(qafName);
                        String qaHome = jsonObject.getString(qafHome);
                        if (Strings.isNullOrEmpty((String)qaName) || Strings.isNullOrEmpty((String)qaHome) || qaInstallationNames.contains(qaName) || !this.isValidString(qaName) || !this.isValidString(qaHome)) {
                            it.remove();
                            continue;
                        }
                        qaInstallationNames.add(qaName);
                    }
                    if (array.isEmpty()) {
                        json = new JSONObject();
                    }
                } else {
                    JSONObject jsonObject = json.getJSONObject(tool);
                    String qaName = jsonObject.getString(qafName);
                    String qaHome = jsonObject.getString(qafHome);
                    if (Strings.isNullOrEmpty((String)qaName) || Strings.isNullOrEmpty((String)qaHome) || !this.isValidString(qaName) || !this.isValidString(qaHome)) {
                        json = new JSONObject();
                    }
                }
            }
            if (configure = super.configure(req, json)) {
                this.save();
            }
            return configure;
        }

        private boolean isValidString(String valid) {
            boolean isValid = true;
            String trim = valid.trim();
            if (Strings.isNullOrEmpty((String)trim) || !valid.equals(trim) || trim.length() < 1) {
                isValid = false;
            }
            return isValid;
        }

        public ListBoxModel doFillQafNameItems() {
            ListBoxModel model = new ListBoxModel();
            for (QAFrameworkInstallationConfiguration suite : this.getQaInstallations()) {
                model.add(suite.getName());
            }
            return model;
        }

        public QAFrameworkInstallationConfiguration[] getQaInstallations() {
            Jenkins instance = Jenkins.getInstanceOrNull();
            if (instance == null) {
                return new QAFrameworkInstallationConfiguration[0];
            }
            return (QAFrameworkInstallationConfiguration[])((DescriptorImpl)instance.getDescriptorByType(DescriptorImpl.class)).getInstallations();
        }

        public FormValidation doCheckQafHome(@QueryParameter String qafHome) {
            if (StringUtils.isBlank((String)qafHome)) {
                return FormValidation.errorWithMarkup((String)"PRQA\u00b7Framework Installation path should not be empty!");
            }
            if (qafHome.startsWith(" ")) {
                return FormValidation.errorWithMarkup((String)"PRQA\u00b7Framework Installation path should not be begin with an empty space!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQafName(@QueryParameter String qafName) {
            if (StringUtils.isBlank((String)qafName)) {
                return FormValidation.errorWithMarkup((String)"The name shall not be empty and shall be unique in the set of PRQA\u00b7Framework installations!");
            }
            if (qafName.startsWith(" ")) {
                return FormValidation.errorWithMarkup((String)"PRQA\u00b7Framework Installation name should not be begin with an empty space!");
            }
            return FormValidation.ok();
        }
    }
}

