/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import com.google.common.collect.Iterables;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import hudson.util.DescribableList;
import hudson.util.RunList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.praqma.jenkins.plugin.prqa.globalconfig.PRQAGlobalConfig;
import net.praqma.jenkins.plugin.prqa.globalconfig.QAVerifyServerConfiguration;
import net.praqma.jenkins.plugin.prqa.notifier.PRQABuildAction;
import net.praqma.jenkins.plugin.prqa.notifier.PRQANotifier;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PRQAProjectAction
extends Actionable
implements ProminentProjectAction {
    private final AbstractProject<?, ?> project;
    private static final String ICON_NAME = "/plugin/prqa-plugin/images/32x32/prqa.png";

    public PRQAProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getDisplayName() {
        return "PRQA Results";
    }

    public String getSearchUrl() {
        return "PRQA";
    }

    public String getIconFileName() {
        return ICON_NAME;
    }

    public String getUrlName() {
        return "PRQA";
    }

    public PRQABuildAction getLatestActionInProject() {
        if (this.project.getLastSuccessfulBuild() != null) {
            return (PRQABuildAction)((AbstractBuild)this.project.getLastSuccessfulBuild()).getAction(PRQABuildAction.class);
        }
        return null;
    }

    public boolean isDrawGraphs() {
        RunList builds = this.project.getBuilds();
        return Iterables.size((Iterable)builds) >= 2;
    }

    public void doReportGraphs(StaplerRequest req, StaplerResponse rsp) {
        PRQABuildAction action = this.getLatestActionInProject();
        if (action != null) {
            try {
                action.doReportGraphs(req, rsp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public QAVerifyServerConfiguration getConfiguration() {
        DescribableList publishersList = this.project.getPublishersList();
        PRQANotifier notifier = (PRQANotifier)publishersList.get(PRQANotifier.class);
        if (notifier != null) {
            List<String> servers = notifier.sourceQAFramework.chosenServers;
            String chosenServer = servers != null && !servers.isEmpty() ? servers.get(0) : null;
            QAVerifyServerConfiguration qavconfig = PRQAGlobalConfig.get().getConfigurationByName(chosenServer);
            return qavconfig;
        }
        return null;
    }

    public Collection<QAVerifyServerConfiguration> getConfigurations() {
        DescribableList publishersList = this.project.getPublishersList();
        PRQANotifier notifier = (PRQANotifier)publishersList.get(PRQANotifier.class);
        if (notifier != null) {
            Collection<QAVerifyServerConfiguration> qavconfig = PRQAGlobalConfig.get().getConfigurationsByNames(notifier.sourceQAFramework.chosenServers);
            return qavconfig;
        }
        return null;
    }

    public boolean showLinksofInterest() {
        DescribableList publishersList = this.project.getPublishersList();
        PRQANotifier notifier = (PRQANotifier)publishersList.get(PRQANotifier.class);
        if (notifier != null && notifier.sourceQAFramework != null) {
            return notifier.sourceQAFramework.loginToQAV;
        }
        return false;
    }
}

