/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.prqa.reports;

import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.praqma.prqa.QAVerifyServerSettings;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.exceptions.PrqaUploadException;
import net.praqma.prqa.execute.PrqaCommandLine;
import net.praqma.prqa.parsers.ComplianceReportHtmlParser;
import net.praqma.prqa.parsers.MessageGroup;
import net.praqma.prqa.parsers.ResultsDataParser;
import net.praqma.prqa.parsers.Rule;
import net.praqma.prqa.products.PRQACommandBuilder;
import net.praqma.prqa.reports.ReportType;
import net.praqma.prqa.status.PRQAComplianceStatus;
import net.praqma.util.execute.AbnormalProcessTerminationException;
import net.praqma.util.execute.CmdResult;
import net.prqma.prqa.qaframework.QaFrameworkReportSettings;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class QAFrameworkReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String XHTML = "xhtml";
    public static final String XML = "xml";
    public static final String HTML = "html";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String QUOTE = "\"";
    private static final Logger log = Logger.getLogger(QAFrameworkReport.class.getName());
    private QaFrameworkReportSettings settings;
    private QAVerifyServerSettings qaVerifySettings;
    private File workspace;
    private Map<String, String> environment;

    public static String extractReportsPath(String root, String qaProject, String configuration) throws PrqaException {
        String path = StringUtils.isEmpty((String)root) ? root : root + File.separator;
        path = PRQACommandBuilder.resolveAbsOrRelativePath(new File(path), qaProject);
        try {
            String cfg = configuration;
            if (StringUtils.isEmpty((String)cfg)) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new File(path, "prqaproject.xml"));
                Element element = document.getDocumentElement();
                XPath xPath = XPathFactory.newInstance().newXPath();
                XPathExpression compile = xPath.compile("/prqaproject/configurations/default_config/@name");
                String name = compile.evaluate(element);
                if (StringUtils.isEmpty((String)name)) {
                    throw new PrqaException("Unable to find default config name in project");
                }
                cfg = name;
            }
            String fmt = "prqa%1$sconfigs%1$s%2$s%1$sreports";
            String reportPath = path + File.separator + String.format("prqa%1$sconfigs%1$s%2$s%1$sreports", File.separator, cfg);
            if (!new File(reportPath).exists()) {
                throw new PrqaException("Configuration does not exist");
            }
            return reportPath;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new PrqaException("Failed to parse project configuration", e);
        }
    }

    public QAFrameworkReport(QaFrameworkReportSettings settings, QAVerifyServerSettings qaVerifySettings, HashMap<String, String> environment) {
        this.settings = settings;
        this.environment = environment;
        this.qaVerifySettings = qaVerifySettings;
    }

    public void pullUnifyProjectQacli(PrintStream out) throws PrqaException {
        if (!this.settings.isLoginToQAV()) {
            out.println("Configuration Error: Download Unified Project is Selected but QAV Server Connection Configuration is not Selected");
        } else {
            out.println("Perform DOWNLOAD UNIFIED PROJECT DEFINITION command:");
            out.println(this.createPullUnifyProjectCommand(true));
            try {
                PrqaCommandLine.getInstance().run(this.createPullUnifyProjectCommand(false), this.workspace, true, false, out);
            }
            catch (AbnormalProcessTerminationException abnex) {
                throw new PrqaException("ERROR: Failed to Download Unified Project, please check the download command message above for more details", abnex);
            }
        }
    }

    private String createPullUnifyProjectCommand(boolean isHidePassword) throws PrqaException {
        if (StringUtils.isBlank((String)this.settings.getUniProjectName())) {
            throw new PrqaException("Configuration Error: Download Unified Project Definition was selected but no Unified project was provided. The Download unified project was aborted.");
        }
        if (StringUtils.isBlank((String)this.qaVerifySettings.host) || StringUtils.isBlank((String)this.qaVerifySettings.user)) {
            throw new PrqaException("QAV Server Connection Settings are not selected");
        }
        PRQACommandBuilder builder = new PRQACommandBuilder(this.formatQacliPath());
        builder.appendArgument("admin");
        builder.appendArgument("--pull-unify-project");
        builder.appendArgument("--qaf-project");
        builder.appendArgument(PRQACommandBuilder.wrapFile(this.workspace, this.settings.getQaProject()));
        builder.appendArgument("--username");
        builder.appendArgument(this.qaVerifySettings.user);
        builder.appendArgument("--password");
        String password = isHidePassword ? "***" : Secret.toString((Secret)this.qaVerifySettings.password);
        builder.appendArgument(password.isEmpty() ? "\"\"" : password);
        builder.appendArgument("--url");
        builder.appendArgument(this.qaVerifySettings.host + ":" + this.qaVerifySettings.port);
        builder.appendArgument("--project-name");
        builder.appendArgument(this.settings.getUniProjectName());
        return builder.getCommand();
    }

    public void analyzeQacli(String options, PrintStream out) throws PrqaException {
        String finalCommand = this.createAnalysisCommandForQacli(options);
        out.println("Perform ANALYSIS command:");
        out.println(finalCommand);
        HashMap<String, String> systemVars = new HashMap<String, String>();
        systemVars.putAll(System.getenv());
        try {
            if (this.getEnvironment() == null) {
                QAFrameworkReport._logEnv("Current analysis execution environment", systemVars);
                PrqaCommandLine.getInstance().run(finalCommand, this.workspace, true, false, out);
            } else {
                systemVars.putAll(this.getEnvironment());
                QAFrameworkReport._logEnv("Current modified analysis execution environment", systemVars);
                PrqaCommandLine.getInstance().run(finalCommand, this.workspace, true, false, systemVars, out);
            }
        }
        catch (AbnormalProcessTerminationException abnex) {
            throw new PrqaException("ERROR: Failed to analyze, please check the analysis command message above for more details", abnex);
        }
    }

    private String createSetCpuThreadsCommand() {
        return new PRQACommandBuilder(this.formatQacliPath()).appendArgument("admin").appendArgument("--set-cpus").appendArgument(this.settings.getMaxNumThreads()).getCommand();
    }

    public void applyCpuThreads(PrintStream out) throws PrqaException {
        String setCpuThreadsCmd = this.createSetCpuThreadsCommand();
        out.println("Perform MAX NUMBER of ANALYSIS THREADS command:");
        out.println(setCpuThreadsCmd);
        try {
            if (this.getEnvironment() == null) {
                PrqaCommandLine.getInstance().run(setCpuThreadsCmd, this.workspace, true, false);
            } else {
                HashMap<String, String> systemVars = new HashMap<String, String>();
                systemVars.putAll(System.getenv());
                systemVars.putAll(this.getEnvironment());
                PrqaCommandLine.getInstance().run(setCpuThreadsCmd, this.workspace, true, false, systemVars);
            }
        }
        catch (AbnormalProcessTerminationException abnex) {
            throw new PrqaException("ERROR: Failed to set the number of CPUs used for analysis, please check the command message above for more details", abnex);
        }
    }

    private String createAnalysisCommandForQacli(String options) throws PrqaException {
        PRQACommandBuilder builder = new PRQACommandBuilder(this.formatQacliPath());
        builder.appendArgument("analyze");
        String analyzeOptions = options;
        if (this.settings.isQaEnableDependencyMode() && analyzeOptions.contains("c")) {
            analyzeOptions = analyzeOptions.replace("c", "");
        }
        builder.appendArgument(analyzeOptions);
        if (this.settings.isAnalysisSettings()) {
            if (this.settings.isStopWhenFail()) {
                builder.appendArgument("--stop-on-fail");
            }
            if (this.settings.isGeneratePreprocess()) {
                builder.appendArgument("--generate-preprocessed-source");
            }
            if (this.settings.isAssembleSupportAnalytics()) {
                if (this.settings.isGeneratePreprocess()) {
                    builder.appendArgument("--assemble-support-analytics");
                } else {
                    log.log(Level.WARNING, "Assemble Support Analytics is selected but Generate Preprocessed Source option is not selected");
                }
            }
        }
        builder.appendArgument("-P");
        builder.appendArgument(PRQACommandBuilder.wrapFile(this.workspace, this.settings.getQaProject()));
        if (StringUtils.isNotEmpty((String)this.settings.getProjectConfiguration())) {
            builder.appendArgument("-K");
            builder.appendArgument(this.settings.getProjectConfiguration());
        }
        return builder.getCommand();
    }

    public void cmaAnalysisQacli(PrintStream out) throws PrqaException {
        if (this.settings.isQaCrossModuleAnalysis()) {
            String command = this.createCmaAnalysisCommand();
            out.println("Perform CROSS-MODULE ANALYSIS command:");
            out.println(command);
            try {
                PrqaCommandLine.getInstance().run(command, this.workspace, true, false, out);
            }
            catch (AbnormalProcessTerminationException abnex) {
                throw new PrqaException("ERROR: Failed to analyze, please check the Cross-Module-Analysis command message above for more details", abnex);
            }
        }
    }

    private String createCmaAnalysisCommand() throws PrqaException {
        PRQACommandBuilder builder = new PRQACommandBuilder(this.formatQacliPath());
        builder.appendArgument("analyze");
        if (this.settings.isReuseCmaDb()) {
            builder.appendArgument("--reuse_db");
        }
        if (this.settings.isUseDiskStorage()) {
            builder.appendArgument("--use_disk_storage");
        }
        builder.appendArgument("-cf");
        builder.appendArgument("-P");
        builder.appendArgument(PRQACommandBuilder.wrapFile(this.workspace, this.settings.getQaProject()));
        builder.appendArgument("-C");
        builder.appendArgument(this.settings.getCmaProjectName());
        if (StringUtils.isNotEmpty((String)this.settings.getProjectConfiguration())) {
            builder.appendArgument("-K");
            builder.appendArgument(this.settings.getProjectConfiguration());
        }
        return builder.getCommand();
    }

    public void reportQacli(String repType, PrintStream out) throws PrqaException {
        String reportCommand = this.createReportCommandForQacli(repType, out);
        HashMap<String, String> systemVars = new HashMap<String, String>();
        systemVars.putAll(System.getenv());
        systemVars.putAll(this.getEnvironment());
        out.println(reportCommand);
        try {
            QAFrameworkReport._logEnv("Current report generation execution environment", systemVars);
            PrqaCommandLine.getInstance().run(reportCommand, this.workspace, true, false, systemVars, out);
            return;
        }
        catch (AbnormalProcessTerminationException abnex) {
            log.severe(String.format("Failed to execute report generation command: %s%n%s", reportCommand, abnex.getMessage()));
            log.logp(Level.SEVERE, this.getClass().getName(), "report()", "Failed to execute report generation command", abnex);
            out.println("Failed to execute report generation command, please check the report command message above for more details");
            new CmdResult();
            return;
        }
    }

    private String createReportCommandForQacli(String reportType, PrintStream out) throws PrqaException {
        out.println("Perform CREATE " + reportType + " REPORT command");
        String projectLocation = PRQACommandBuilder.resolveAbsOrRelativePath(this.workspace, this.settings.getQaProject());
        this.removeOldReports(this.workspace.getAbsolutePath(), reportType);
        return this.createReportCommand(projectLocation, reportType);
    }

    private String createReportCommand(String projectLocation, String reportType) {
        PRQACommandBuilder builder = new PRQACommandBuilder(this.formatQacliPath());
        builder.appendArgument("report -P");
        builder.appendArgument(PRQACommandBuilder.wrapInQuotationMarks(projectLocation));
        builder.appendArgument("-t");
        builder.appendArgument(reportType);
        if (StringUtils.isNotEmpty((String)this.settings.getProjectConfiguration())) {
            builder.appendArgument("-K");
            builder.appendArgument(this.settings.getProjectConfiguration());
        }
        return builder.getCommand();
    }

    private void removeOldReports(String projectLocation, String reportType) throws PrqaException {
        File[] files;
        File file = new File(QAFrameworkReport.extractReportsPath(projectLocation, this.settings.getQaProject(), this.settings.getProjectConfiguration()));
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                if (!(f.getName().contains(ReportType.RCR.name()) && reportType.equals(ReportType.RCR.name()) || f.getName().contains(ReportType.CRR.name()) && reportType.equals(ReportType.CRR.name()) || f.getName().contains(ReportType.MDR.name()) && reportType.equals(ReportType.MDR.name()) || f.getName().contains(ReportType.SUR.name()) && reportType.equals(ReportType.SUR.name())) && !f.getName().contains("results_data") || !f.delete()) continue;
                log.finest("Deleted old report " + f.getAbsolutePath());
            }
        }
    }

    private String createUploadCommandQacli(boolean isHidePassword) throws PrqaException {
        if (StringUtils.isBlank((String)this.settings.getQaVerifyProjectName())) {
            throw new PrqaException("Neither file list nor project file has been set, this should not be happening");
        }
        String projectLocation = PRQACommandBuilder.wrapFile(this.workspace, this.settings.getQaProject());
        PRQACommandBuilder builder = new PRQACommandBuilder(this.formatQacliPath());
        builder.appendArgument("upload -P");
        builder.appendArgument(projectLocation);
        builder.appendArgument("--qav-upload");
        builder.appendArgument("--username");
        builder.appendArgument(this.qaVerifySettings.user);
        builder.appendArgument("--password");
        String password = isHidePassword ? "***" : Secret.toString((Secret)this.qaVerifySettings.password);
        builder.appendArgument(password.isEmpty() ? "\"\"" : password);
        builder.appendArgument("--url");
        builder.appendArgument(this.qaVerifySettings.host + ":" + this.qaVerifySettings.port);
        builder.appendArgument("--upload-project");
        builder.appendArgument(this.settings.getQaVerifyProjectName());
        if (StringUtils.isNotEmpty((String)this.settings.getUploadSnapshotName())) {
            builder.appendArgument("--snapshot-name");
            if (this.settings.isAddBuildNumber()) {
                builder.appendArgument(this.settings.getUploadSnapshotName() + '_' + this.settings.getbuildNumber());
            } else {
                builder.appendArgument(this.settings.getUploadSnapshotName());
            }
        }
        builder.appendArgument("--upload-source");
        builder.appendArgument(this.settings.getUploadSourceCode());
        if (StringUtils.isNotEmpty((String)this.settings.getProjectConfiguration())) {
            builder.appendArgument("-K");
            builder.appendArgument(this.settings.getProjectConfiguration());
        }
        return builder.getCommand();
    }

    public void uploadQacli(PrintStream out) throws PrqaException {
        if (!this.settings.isLoginToQAV()) {
            out.println("Configuration Error: Upload Results to QAV is Selected but QAV Server Connection Configuration is not Selected");
            return;
        }
        out.println("Perform UPLOAD command: " + this.createUploadCommandQacli(true));
        try {
            Map<String, String> getEnv = this.getEnvironment();
            if (getEnv == null) {
                PrqaCommandLine.getInstance().run(this.createUploadCommandQacli(false), this.workspace, true, false, out);
            } else {
                PrqaCommandLine.getInstance().run(this.createUploadCommandQacli(false), this.workspace, true, false, getEnv, out);
            }
        }
        catch (AbnormalProcessTerminationException abnex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "upload()", "Logged error with upload", abnex);
            throw new PrqaUploadException("ERROR: Failed to upload, please check the upload command message above for more details", (Exception)((Object)abnex));
        }
    }

    private String formatQacliPath() {
        if (this.environment.containsKey("QAFBINPATH")) {
            return QUOTE + this.environment.get("QAFBINPATH") + FILE_SEPARATOR + "qacli" + QUOTE;
        }
        return "qacli";
    }

    public static void _logEnv(String location, Map<String, String> env) {
        log.fine(String.format("%s", location));
        log.fine("==========================================");
        if (env != null) {
            for (String key : env.keySet()) {
                log.fine(String.format("%s=%s", key, env.get(key)));
            }
        }
        log.fine("==========================================");
    }

    public PRQAComplianceStatus getComplianceStatus(PrintStream out) throws PrqaException {
        List<MessageGroup> messagesGroups;
        PRQAComplianceStatus status = new PRQAComplianceStatus();
        String report_structure = new File(QAFrameworkReport.extractReportsPath(this.workspace.getAbsolutePath(), this.settings.getQaProject(), this.settings.getProjectConfiguration())).getPath();
        File reportFolder = new File(report_structure);
        out.println("Report Folder Path: " + reportFolder);
        File resultsDataFile = new File(reportFolder + File.separator + "results_data.xml");
        out.println("Results Data File Path: " + resultsDataFile.getPath());
        if (!(reportFolder.exists() && reportFolder.isDirectory() && resultsDataFile.exists() && resultsDataFile.isFile())) {
            return status;
        }
        File[] listOfReports = reportFolder.listFiles();
        if (listOfReports != null && listOfReports.length < 1) {
            return status;
        }
        Double fileCompliance = 0.0;
        Double projectCompliance = 0.0;
        int messages = 0;
        if (listOfReports != null) {
            for (File reportFile : listOfReports) {
                if (!reportFile.getName().contains(ReportType.RCR.name())) continue;
                ComplianceReportHtmlParser parser = new ComplianceReportHtmlParser(reportFile.getAbsolutePath());
                fileCompliance = fileCompliance + Double.parseDouble(parser.getParseFirstResult(ComplianceReportHtmlParser.QAFfileCompliancePattern));
                projectCompliance = projectCompliance + Double.parseDouble(parser.getParseFirstResult(ComplianceReportHtmlParser.QAFprojectCompliancePattern));
                messages += Integer.parseInt(parser.getParseFirstResult(ComplianceReportHtmlParser.QAFtotalMessagesPattern));
            }
        }
        ResultsDataParser resultsDataParser = new ResultsDataParser(resultsDataFile.getAbsolutePath());
        try {
            messagesGroups = resultsDataParser.parseResultsData();
        }
        catch (Exception e) {
            throw new PrqaException(e);
        }
        this.sortViolatedRulesByRuleID(messagesGroups);
        status.setMessagesGroups(messagesGroups);
        status.setFileCompliance(fileCompliance);
        status.setProjectCompliance(projectCompliance);
        status.setMessages(messages);
        return status;
    }

    private void sortViolatedRulesByRuleID(List<MessageGroup> messagesGroups) {
        for (MessageGroup messageGroup : messagesGroups) {
            Collections.sort(messageGroup.getViolatedRules(), new Comparator<Rule>(){

                @Override
                public int compare(Rule o1, Rule o2) {
                    return o1.getRuleID().compareTo(o2.getRuleID());
                }
            });
        }
    }

    public void setWorkspace(File workspace) {
        this.workspace = workspace;
    }

    public QaFrameworkReportSettings getSettings() {
        return this.settings;
    }

    public void setSettings(QaFrameworkReportSettings settings) {
        this.settings = settings;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public boolean applyCustomLicenseServer(PrintStream out) throws PrqaException {
        if (!this.settings.isUseCustomLicenseServer()) {
            return false;
        }
        if (this.isCustomServerAlreadySet(out)) {
            return false;
        }
        String setLicenseServerCmd = this.createSetLicenseServersCmd();
        out.println("Perform SET CUSTOM LICENSE SERVER command:");
        out.println(setLicenseServerCmd);
        try {
            if (this.getEnvironment() == null) {
                PrqaCommandLine.getInstance().run(setLicenseServerCmd, this.workspace, true, false, out);
            } else {
                HashMap<String, String> systemVars = new HashMap<String, String>();
                systemVars.putAll(System.getenv());
                systemVars.putAll(this.getEnvironment());
                PrqaCommandLine.getInstance().run(setLicenseServerCmd, this.workspace, true, false, systemVars, out);
            }
        }
        catch (AbnormalProcessTerminationException abnex) {
            throw new PrqaException(String.format("ERROR: Failed to set license server, message is... \n %s ", abnex.getMessage()), abnex);
        }
        return true;
    }

    public void unsetCustomLicenseServer(boolean wasApplied, PrintStream out) throws PrqaException {
        if (!wasApplied || !this.settings.isUseCustomLicenseServer()) {
            return;
        }
        String setLicenseServerCmd = this.createRemoveLicenseServersCmd();
        out.println("Perform REMOVE CUSTOM LICENSE SERVER command:");
        out.println(setLicenseServerCmd);
        try {
            if (this.getEnvironment() == null) {
                PrqaCommandLine.getInstance().run(setLicenseServerCmd, this.workspace, true, false, out);
            } else {
                HashMap<String, String> systemVars = new HashMap<String, String>();
                systemVars.putAll(System.getenv());
                systemVars.putAll(this.getEnvironment());
                PrqaCommandLine.getInstance().run(setLicenseServerCmd, this.workspace, true, false, systemVars, out);
            }
        }
        catch (AbnormalProcessTerminationException abnex) {
            throw new PrqaException(String.format("ERROR: Failed to remove license , message is... \n %s ", abnex.getMessage()), abnex);
        }
    }

    private boolean isCustomServerAlreadySet(PrintStream out) throws PrqaException {
        CmdResult res;
        String listLicenseServersCmd = this.createListLicenseServersCmd();
        out.println("Perform LIST LICENSE SERVERS command:");
        out.println(listLicenseServersCmd);
        try {
            if (this.getEnvironment() == null) {
                res = PrqaCommandLine.getInstance().run(listLicenseServersCmd, this.workspace, false, true, out);
            } else {
                HashMap<String, String> systemVars = new HashMap<String, String>();
                systemVars.putAll(System.getenv());
                systemVars.putAll(this.getEnvironment());
                res = PrqaCommandLine.getInstance().run(listLicenseServersCmd, this.workspace, false, true, systemVars, out);
            }
        }
        catch (AbnormalProcessTerminationException abnex) {
            throw new PrqaException(String.format("ERROR: Failed to list current servers, message is... \n %s ", abnex.getMessage()), abnex);
        }
        boolean contains = StringUtils.contains((String)res.stdoutBuffer.toString(), (String)this.settings.getCustomLicenseServerAddress());
        if (contains) {
            out.println("Custom license server already set");
        } else {
            out.println("Custom license server not set");
        }
        return contains;
    }

    private String createListLicenseServersCmd() {
        PRQACommandBuilder builder = new PRQACommandBuilder(this.formatQacliPath());
        builder.appendArgument("admin");
        builder.appendArgument("--list-license-servers");
        return builder.getCommand();
    }

    private String createSetLicenseServersCmd() {
        PRQACommandBuilder builder = new PRQACommandBuilder(this.formatQacliPath());
        builder.appendArgument("admin");
        builder.appendArgument("--set-license-server");
        builder.appendArgument(this.settings.getCustomLicenseServerAddress());
        return builder.getCommand();
    }

    private String createRemoveLicenseServersCmd() {
        PRQACommandBuilder builder = new PRQACommandBuilder(this.formatQacliPath());
        builder.appendArgument("admin");
        builder.appendArgument("--remove-license-server");
        builder.appendArgument(this.settings.getCustomLicenseServerAddress());
        return builder.getCommand();
    }
}

