/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.prqa.execute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class StreamGobbler
extends Thread {
    protected static Logger logger = Logger.getLogger(StreamGobbler.class.getName());
    public static final String linesep = System.getProperty("line.separator");
    InputStream is;
    PrintStream printStream;
    public StringBuffer sres;
    public List<String> lres;

    StreamGobbler(InputStream is) {
        this.is = is;
        this.lres = new ArrayList<String>();
        this.sres = new StringBuffer();
    }

    StreamGobbler(InputStream is, PrintStream printStream) {
        this.is = is;
        this.printStream = printStream;
        this.lres = new ArrayList<String>();
        this.sres = new StringBuffer();
    }

    public StringBuffer getResultBuffer() {
        return this.sres;
    }

    public List<String> getResultList() {
        return this.lres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.is));){
            String line;
            while ((line = br.readLine()) != null) {
                this.lres.add(line);
                if (this.printStream == null) continue;
                this.printStream.println(" > ".concat(line));
            }
            for (int i = 0; i < this.lres.size() - 1; ++i) {
                this.sres.append(this.lres.get(i) + linesep);
            }
            if (this.lres.size() > 0) {
                this.sres.append(this.lres.get(this.lres.size() - 1));
            }
            StreamGobbler streamGobbler = this;
            synchronized (streamGobbler) {
                this.notifyAll();
            }
        }
        catch (IOException ioe) {
            logger.severe("Could not read line from input stream.");
            ioe.printStackTrace();
        }
    }
}

