/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.threshold;

import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import java.util.logging.Logger;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import net.praqma.jenkins.plugin.prqa.notifier.ThresholdSelectionDescriptor;
import net.praqma.jenkins.plugin.prqa.threshold.AbstractThreshold;
import net.praqma.prqa.parsers.MessageGroup;
import net.praqma.prqa.status.PRQAComplianceStatus;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class MessageComplianceThreshold
extends AbstractThreshold {
    public final Integer value;
    public final int thresholdLevel;
    private static final Logger log = Logger.getLogger(MessageComplianceThreshold.class.getName());

    @DataBoundConstructor
    public MessageComplianceThreshold(Integer value, int thresholdLevel, Boolean improvement) {
        super(improvement);
        this.value = value;
        this.thresholdLevel = thresholdLevel;
    }

    @Override
    public boolean validateImprovement(PRQAComplianceStatus previousComplianceStatus, PRQAComplianceStatus currentComplianceStatus) {
        return this.value == null || this.isImprovementForMessageGroups(previousComplianceStatus, currentComplianceStatus, this.thresholdLevel);
    }

    private boolean isImprovementForMessageGroups(PRQAComplianceStatus previousComplianceStatus, PRQAComplianceStatus currentComplianceStatus, int thresholdLevel) {
        boolean areAllMessagesValid = true;
        List<MessageGroup> currentComplianceStatusMessageGroups = currentComplianceStatus.getMessagesGroups();
        if (currentComplianceStatusMessageGroups == null || currentComplianceStatusMessageGroups.isEmpty()) {
            boolean bl = areAllMessagesValid = currentComplianceStatus.getMessageCount(thresholdLevel) <= previousComplianceStatus.getMessageCount(thresholdLevel);
            if (!areAllMessagesValid) {
                currentComplianceStatus.addNotification(Messages.PRQANotifier_MaxMessagesRequirementNotMetExistingPrqa(currentComplianceStatus.getMessageCount(thresholdLevel), previousComplianceStatus.getMessageCount(thresholdLevel)));
            }
        } else {
            List<MessageGroup> previousComplianceStatusMessageGroups = previousComplianceStatus.getMessagesGroups();
            for (int i = 0; i < currentComplianceStatusMessageGroups.size(); ++i) {
                MessageGroup currentMessageGroup = currentComplianceStatusMessageGroups.get(i);
                for (int j = 0; j < previousComplianceStatusMessageGroups.size(); ++j) {
                    if (!currentMessageGroup.getMessageGroupName().equals(previousComplianceStatusMessageGroups.get(j).getMessageGroupName()) || currentMessageGroup.getMessagesWithinThreshold() > previousComplianceStatusMessageGroups.get(j).getMessagesWithinThreshold()) continue;
                    currentComplianceStatus.addNotification(this.onUnstableMessage(currentMessageGroup.getMessageGroupName(), currentMessageGroup.getMessagesWithinThreshold(), previousComplianceStatusMessageGroups.get(j).getMessagesWithinThreshold()));
                    areAllMessagesValid = false;
                }
            }
        }
        return areAllMessagesValid;
    }

    private String onUnstableMessage(String messageGroupName, int actualValue, int comparisonValue) {
        return Messages.PRQANotifier_MaxMessagesRequirementNotMet(messageGroupName, actualValue, comparisonValue);
    }

    @Override
    public boolean validateThreshold(PRQAComplianceStatus currentComplianceStatus) {
        return this.value == null || this.isTresholdValidForMessageGroups(currentComplianceStatus, this.thresholdLevel);
    }

    private boolean isTresholdValidForMessageGroups(PRQAComplianceStatus currentComplianceStatus, int thresholdLevel) {
        boolean isStableBuild = true;
        List<MessageGroup> messageGroups = currentComplianceStatus.getMessagesGroups();
        if (messageGroups == null || messageGroups.isEmpty()) {
            boolean isValidTreshold;
            boolean bl = isValidTreshold = currentComplianceStatus.getMessageCount(thresholdLevel) <= this.value;
            if (!isValidTreshold) {
                currentComplianceStatus.addNotification(Messages.PRQANotifier_MaxMessagesRequirementNotMetExistingPrqa(currentComplianceStatus.getMessageCount(thresholdLevel), this.value));
            }
        } else {
            for (MessageGroup messageGroup : currentComplianceStatus.getMessagesGroups()) {
                boolean isValidTreshold;
                boolean bl = isValidTreshold = messageGroup.getMessagesWithinThreshold() <= this.value;
                if (!isValidTreshold) {
                    currentComplianceStatus.addNotification(this.onUnstableMessage(messageGroup.getMessageGroupName(), messageGroup.getMessagesWithinThreshold(), this.value));
                    isStableBuild = false;
                }
                log.fine(String.format("For %s are %s mesages, comparing to: %s", messageGroup.getMessageGroupName(), messageGroup.getMessagesWithinThreshold(), this.value));
                log.fine(String.format("ValidateThreshold returned %s", isValidTreshold));
            }
        }
        return isStableBuild;
    }

    @Extension
    public static final class DescriptorImpl
    extends ThresholdSelectionDescriptor<MessageComplianceThreshold> {
        public String getDisplayName() {
            return "Message Compliance Threshold";
        }

        public ListBoxModel doFillThresholdLevelItems() {
            ListBoxModel model = new ListBoxModel();
            for (int i = 0; i < 10; ++i) {
                model.add(String.valueOf(i));
            }
            return model;
        }

        @Override
        public FormValidation doCheckValue(@QueryParameter String value, @QueryParameter boolean improvement) {
            if (!improvement) {
                if (StringUtils.isEmpty((String)value)) {
                    return FormValidation.ok();
                }
                try {
                    Integer parsedValue = Integer.parseInt(value);
                    if (parsedValue < 0) {
                        return FormValidation.error((String)Messages.PRQANotifier_WrongInteger());
                    }
                }
                catch (NumberFormatException ex) {
                    return FormValidation.error((String)Messages.PRQANotifier_UseNoDecimals());
                }
            }
            return FormValidation.ok();
        }

        public String getHelpFile() {
            return "/plugin/prqa-plugin/config/help-thresholds-message.html";
        }
    }
}

