/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.ArtifactManager;
import jenkins.model.Jenkins;
import jenkins.util.BuildListenerAdapter;
import net.praqma.jenkins.plugin.prqa.PRQARemoteToolCheck;
import net.praqma.jenkins.plugin.prqa.QAFrameworkRemoteReport;
import net.praqma.jenkins.plugin.prqa.QAFrameworkRemoteReportUpload;
import net.praqma.jenkins.plugin.prqa.VersionInfo;
import net.praqma.jenkins.plugin.prqa.globalconfig.PRQAGlobalConfig;
import net.praqma.jenkins.plugin.prqa.globalconfig.QAVerifyServerConfiguration;
import net.praqma.jenkins.plugin.prqa.graphs.ComplianceIndexGraphs;
import net.praqma.jenkins.plugin.prqa.graphs.MessagesGraph;
import net.praqma.jenkins.plugin.prqa.graphs.PRQAGraph;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import net.praqma.jenkins.plugin.prqa.notifier.PRQABuildAction;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAProjectAction;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAReportSourceDescriptor;
import net.praqma.jenkins.plugin.prqa.notifier.PostBuildActionSetup;
import net.praqma.jenkins.plugin.prqa.notifier.QAFrameworkPostBuildActionSetup;
import net.praqma.jenkins.plugin.prqa.notifier.ThresholdSelectionDescriptor;
import net.praqma.jenkins.plugin.prqa.notifier.slave.filesystem.CopyReportsToWorkspace;
import net.praqma.jenkins.plugin.prqa.notifier.slave.filesystem.DeleteReportsFromWorkspace;
import net.praqma.jenkins.plugin.prqa.setup.QAFrameworkInstallationConfiguration;
import net.praqma.jenkins.plugin.prqa.threshold.AbstractThreshold;
import net.praqma.jenkins.plugin.prqa.threshold.FileComplianceThreshold;
import net.praqma.jenkins.plugin.prqa.threshold.MessageComplianceThreshold;
import net.praqma.jenkins.plugin.prqa.threshold.ProjectComplianceThreshold;
import net.praqma.jenkins.plugin.prqa.utils.PRQABuildUtils;
import net.praqma.prqa.PRQAApplicationSettings;
import net.praqma.prqa.PRQAContext;
import net.praqma.prqa.PRQAReading;
import net.praqma.prqa.QAVerifyServerSettings;
import net.praqma.prqa.QaFrameworkVersion;
import net.praqma.prqa.ReportSettings;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.exceptions.PrqaSetupException;
import net.praqma.prqa.products.QACli;
import net.praqma.prqa.reports.QAFrameworkReport;
import net.praqma.prqa.reports.ReportType;
import net.praqma.prqa.status.PRQAComplianceStatus;
import net.praqma.prqa.status.StatusCategory;
import net.prqma.prqa.qaframework.QaFrameworkReportSettings;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class PRQANotifier
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(PRQANotifier.class.getName());
    private transient PrintStream outStream;
    private List<PRQAGraph> graphTypes;
    public final String settingProjectCompliance;
    public final String snapshotName;
    public QAFrameworkPostBuildActionSetup sourceQAFramework;
    public final List<AbstractThreshold> thresholdsDesc;
    public final String product;
    public final boolean runWhenSuccess;
    public EnumSet<PRQAContext.QARReportType> chosenReportTypes;

    @DataBoundConstructor
    public PRQANotifier(String product, boolean runWhenSuccess, String settingProjectCompliance, String snapshotName, QAFrameworkPostBuildActionSetup sourceQAFramework, List<AbstractThreshold> thresholdsDesc) {
        this.product = product;
        this.runWhenSuccess = runWhenSuccess;
        this.settingProjectCompliance = settingProjectCompliance;
        this.snapshotName = snapshotName;
        this.sourceQAFramework = sourceQAFramework;
        this.thresholdsDesc = thresholdsDesc;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PRQAProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    private void copyResourcesToArtifactsDir(String pattern, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath buildWorkspace = build.getWorkspace();
        if (buildWorkspace == null) {
            return;
        }
        FilePath[] files = buildWorkspace.list("**/" + pattern);
        HashMap<String, String> artifacts = new HashMap<String, String>();
        for (FilePath file : files) {
            artifacts.put(file.getName(), StringUtils.replace((String)file.getRemote(), (String)buildWorkspace.getRemote(), (String)""));
        }
        if (artifacts.isEmpty()) {
            return;
        }
        BuildListenerAdapter adapter = new BuildListenerAdapter((TaskListener)listener);
        ArtifactManager artifactManager = build.pickArtifactManager();
        Launcher launcher = buildWorkspace.createLauncher((TaskListener)adapter);
        artifactManager.archive(buildWorkspace, launcher, (BuildListener)adapter, artifacts);
    }

    private boolean evaluate(PRQAReading previousStableComplianceStatus, List<? extends AbstractThreshold> thresholds, PRQAComplianceStatus currentComplianceStatus) {
        PRQAComplianceStatus previousComplianceStatus = (PRQAComplianceStatus)previousStableComplianceStatus;
        HashMap<StatusCategory, Number> tholds = new HashMap<StatusCategory, Number>();
        if (thresholds == null) {
            return true;
        }
        for (AbstractThreshold abstractThreshold : thresholds) {
            if (abstractThreshold.improvement.booleanValue()) {
                if (this.isBuildStableForContinuousImprovement(abstractThreshold, currentComplianceStatus, previousComplianceStatus)) continue;
                return false;
            }
            this.addThreshold(abstractThreshold, tholds);
            currentComplianceStatus.setThresholds(tholds);
            if (abstractThreshold.validate(previousComplianceStatus, currentComplianceStatus)) continue;
            return false;
        }
        return true;
    }

    private boolean isBuildStableForContinuousImprovement(AbstractThreshold threshold, PRQAComplianceStatus currentComplianceStatus, PRQAComplianceStatus previousComplianceStatus) {
        if (threshold instanceof MessageComplianceThreshold) {
            if (currentComplianceStatus.getMessages() > previousComplianceStatus.getMessages()) {
                currentComplianceStatus.addNotification(Messages.PRQANotifier_MaxMessagesContinuousImprovementRequirementNotMet(previousComplianceStatus.getMessages(), currentComplianceStatus.getMessages()));
                return false;
            }
        } else if (threshold instanceof FileComplianceThreshold) {
            if (currentComplianceStatus.getFileCompliance() < previousComplianceStatus.getFileCompliance()) {
                currentComplianceStatus.addNotification(Messages.PRQANotifier_FileComplianceContinuousImprovementRequirementNotMet(previousComplianceStatus.getFileCompliance() + "%", currentComplianceStatus.getFileCompliance()) + "%");
                return false;
            }
        } else if (threshold instanceof ProjectComplianceThreshold && currentComplianceStatus.getProjectCompliance() < previousComplianceStatus.getProjectCompliance()) {
            currentComplianceStatus.addNotification(Messages.PRQANotifier_ProjectComplianceContinuousImprovementRequirementNotMet(previousComplianceStatus.getProjectCompliance() + "%", currentComplianceStatus.getProjectCompliance()) + "%");
            return false;
        }
        return true;
    }

    private void addThreshold(AbstractThreshold threshold, HashMap<StatusCategory, Number> tholds) {
        if (threshold instanceof ProjectComplianceThreshold) {
            tholds.put(StatusCategory.ProjectCompliance, ((ProjectComplianceThreshold)threshold).value);
        } else if (threshold instanceof FileComplianceThreshold) {
            tholds.put(StatusCategory.FileCompliance, ((FileComplianceThreshold)threshold).value);
        } else {
            tholds.put(StatusCategory.Messages, ((MessageComplianceThreshold)threshold).value);
        }
    }

    private void copyReportsToArtifactsDir(ReportSettings settings, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath buildWorkspace = build.getWorkspace();
        if (buildWorkspace == null) {
            throw new IOException("Invalid workspace");
        }
        if (settings instanceof QaFrameworkReportSettings) {
            QaFrameworkReportSettings qaFrameworkSettings = (QaFrameworkReportSettings)settings;
            this.copyGeneratedReportsToJobWorkspace(build, qaFrameworkSettings.getQaProject(), qaFrameworkSettings.getProjectConfiguration());
            this.copyReportsFromWorkspaceToArtifactsDir(build, listener);
        }
    }

    private void copyGeneratedReportsToJobWorkspace(AbstractBuild<?, ?> build, String qaProject, String projectConfiguration) throws IOException, InterruptedException {
        FilePath buildWorkspace = build.getWorkspace();
        if (buildWorkspace == null) {
            throw new IOException("Invalid workspace");
        }
        buildWorkspace.act((FilePath.FileCallable)new CopyReportsToWorkspace(qaProject, projectConfiguration));
    }

    private boolean containsReportName(String fileName) {
        return fileName.contains(ReportType.CRR.name()) || fileName.contains(ReportType.SUR.name()) || fileName.contains(ReportType.RCR.name()) || fileName.contains(ReportType.MDR.name());
    }

    private void copyReportsFromWorkspaceToArtifactsDir(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath file;
        FilePath buildWorkspace = build.getWorkspace();
        if (buildWorkspace == null) {
            throw new IOException("Invalid workspace");
        }
        List workspaceFiles = buildWorkspace.list();
        if (workspaceFiles.isEmpty()) {
            return;
        }
        Collections.sort(workspaceFiles, new Comparator<FilePath>(){

            @Override
            public int compare(FilePath o1, FilePath o2) {
                try {
                    return Long.compare(o2.lastModified(), o1.lastModified());
                }
                catch (IOException | InterruptedException e) {
                    return 0;
                }
            }
        });
        HashMap<String, String> artifacts = new HashMap<String, String>();
        Iterator iterator = workspaceFiles.iterator();
        while (iterator.hasNext() && (file = (FilePath)iterator.next()).lastModified() >= build.getTimeInMillis()) {
            if (!this.containsReportName(file.getName())) continue;
            artifacts.put(file.getName(), file.getName());
        }
        if (artifacts.isEmpty()) {
            return;
        }
        BuildListenerAdapter adapter = new BuildListenerAdapter((TaskListener)listener);
        Launcher launcher = buildWorkspace.createLauncher((TaskListener)adapter);
        ArtifactManager artifactManager = build.pickArtifactManager();
        artifactManager.archive(buildWorkspace, launcher, (BuildListener)adapter, artifacts);
    }

    public List<PRQAGraph> getSupportedGraphs() {
        ArrayList<PRQAGraph> graphs = new ArrayList<PRQAGraph>();
        for (PRQAGraph g : this.graphTypes) {
            if (!g.getType().equals((Object)PRQAContext.QARReportType.Compliance)) continue;
            graphs.add(g);
        }
        return graphs;
    }

    public PRQAGraph getGraph(String simpleClassName) {
        for (PRQAGraph p : this.getSupportedGraphs()) {
            if (!p.getClass().getSimpleName().equals(simpleClassName)) continue;
            return p;
        }
        return null;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        boolean success = false;
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            listener.getLogger().println("Invalid workspace. Cannot continue.");
            return false;
        }
        DeleteReportsFromWorkspace deleter = new DeleteReportsFromWorkspace();
        try {
            success = (Boolean)workspace.act((FilePath.FileCallable)deleter);
        }
        catch (IOException | InterruptedException ex) {
            log.log(Level.SEVERE, "Cleanup crew missing!", ex);
            listener.getLogger().println(ex.getMessage());
        }
        if (!success) {
            listener.getLogger().println("Failed to cleanup workspace reports.");
            build.setResult(Result.FAILURE);
        }
        return success;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.outStream = listener.getLogger();
        Result buildResult = build.getResult();
        if (buildResult == null) {
            log.log(Level.WARNING, "Build result is unavailable at this point.");
            this.outStream.println("Build result is unavailable at this point. Will not proceed.");
            return false;
        }
        if (buildResult.isWorseOrEqualTo(Result.FAILURE)) {
            log.log(Level.WARNING, "Build is marked as failure.");
            if (this.runWhenSuccess) {
                this.outStream.println("Build is marked as failure and PRQA Analysis will not proceed.");
                return false;
            }
            this.outStream.println("Build is marked as failure but PRQA Analysis will proceed.");
        }
        return this.performQaFrameworkBuild(build, launcher, listener);
    }

    public EnumSet<PRQAContext.QARReportType> getChosenReportTypes() {
        return this.chosenReportTypes;
    }

    public void setChosenReportTypes(EnumSet<PRQAContext.QARReportType> chosenReport) {
        this.chosenReportTypes = chosenReport;
    }

    public boolean enter() {
        return true;
    }

    private Pair<PRQAReading, AbstractBuild<?, ?>> getPreviousReading(AbstractBuild<?, ?> currentBuild, Result expectedResult) {
        AbstractBuild iterate = currentBuild;
        do {
            if ((iterate = (AbstractBuild)iterate.getPreviousNotFailedBuild()) == null || iterate.getAction(PRQABuildAction.class) == null || !Objects.equals(iterate.getResult(), expectedResult)) continue;
            AbstractBuild second = iterate;
            Pair result = Pair.of((Object)((PRQABuildAction)iterate.getAction(PRQABuildAction.class)).getResult(), (Object)second);
            return result;
        } while (iterate != null);
        return null;
    }

    @Exported
    public void setGraphTypes(List<PRQAGraph> graphTypes) {
        this.graphTypes = graphTypes;
    }

    @Exported
    public List<PRQAGraph> getGraphTypes() {
        return this.graphTypes;
    }

    private boolean performQaFrameworkBuild(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PRQAComplianceStatus currentBuild;
        QaFrameworkReportSettings qaReportSettings;
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IOException("Invalid workspace. Cannot continue.");
        }
        Computer currentComputer = Computer.currentComputer();
        if (currentComputer == null) {
            throw new IOException("Invalid machine. Cannot continue.");
        }
        Node node = currentComputer.getNode();
        if (node == null) {
            throw new IOException("Invalid machine. Cannot continue.");
        }
        QAFrameworkPostBuildActionSetup qaFrameworkPostBuildActionSetup = this.sourceQAFramework;
        QAFrameworkInstallationConfiguration qaFrameworkInstallationConfiguration = QAFrameworkInstallationConfiguration.getInstallationByName(qaFrameworkPostBuildActionSetup.qaInstallation);
        if (qaFrameworkInstallationConfiguration == null) {
            String msg = String.format("The job uses a QA Framework installation (%s) that is misconfigured or no longer exists, please reconfigure.", qaFrameworkPostBuildActionSetup.qaInstallation);
            log.log(Level.SEVERE, msg);
            this.outStream.println(msg);
            build.setResult(Result.FAILURE);
            return false;
        }
        qaFrameworkInstallationConfiguration = qaFrameworkInstallationConfiguration.forNode(node, (TaskListener)listener);
        this.outStream.println(String.format("Programming Research Quality Assurance Plugin version %s", VersionInfo.getPluginVersion()));
        QAFrameworkInstallationConfiguration suite = qaFrameworkInstallationConfiguration;
        this.outStream.println(Messages.PRQANotifier_ReportGenerateText());
        this.outStream.println("Workspace : " + workspace.getRemote());
        HashMap<String, String> environmentVariables = suite.createEnvironmentVariables(workspace.getRemote());
        PRQAApplicationSettings appSettings = new PRQAApplicationSettings(qaFrameworkInstallationConfiguration.getHome());
        try {
            qaReportSettings = this.setQaFrameworkReportSettings(qaFrameworkPostBuildActionSetup, build, listener);
        }
        catch (PrqaSetupException ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
            this.outStream.println(ex.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        ArrayList<QAFrameworkRemoteReport> remoteReports = new ArrayList<QAFrameworkRemoteReport>();
        ArrayList<QAFrameworkRemoteReportUpload> remoteReportUploads = new ArrayList<QAFrameworkRemoteReportUpload>();
        if (qaFrameworkPostBuildActionSetup.chosenServers != null && !qaFrameworkPostBuildActionSetup.chosenServers.isEmpty()) {
            for (String chosenServer : qaFrameworkPostBuildActionSetup.chosenServers) {
                QAVerifyServerSettings qaVerifySettings = this.setQaVerifyServerSettings(chosenServer);
                QAFrameworkReport report = new QAFrameworkReport(qaReportSettings, qaVerifySettings, environmentVariables);
                remoteReports.add(new QAFrameworkRemoteReport(report, listener));
                remoteReportUploads.add(new QAFrameworkRemoteReportUpload(report, listener));
            }
        } else {
            QAFrameworkReport report = new QAFrameworkReport(qaReportSettings, this.setQaVerifyServerSettings(null), environmentVariables);
            remoteReports.add(new QAFrameworkRemoteReport(report, listener));
        }
        PRQARemoteToolCheck remoteToolCheck = new PRQARemoteToolCheck(new QACli(), environmentVariables, appSettings, qaReportSettings, listener, launcher.isUnix());
        try {
            QAFrameworkRemoteReport remoteReport = (QAFrameworkRemoteReport)((Object)remoteReports.iterator().next());
            currentBuild = this.performBuild(build, remoteToolCheck, remoteReport, qaReportSettings, listener);
        }
        catch (PrqaException ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
            this.outStream.println(ex.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        Pair<PRQAReading, AbstractBuild<?, ?>> previousBuildResultTuple = this.getPreviousReading(build, Result.SUCCESS);
        PRQAReading previousStableBuildResult = previousBuildResultTuple != null ? (PRQAReading)previousBuildResultTuple.getKey() : null;
        log.fine("thresholdsDesc is null: " + (this.thresholdsDesc == null));
        if (this.thresholdsDesc != null) {
            log.fine("thresholdsDescSize: " + this.thresholdsDesc.size());
        }
        boolean thresholdEvalResult = this.evaluate(previousStableBuildResult, this.thresholdsDesc, currentBuild);
        log.fine("Evaluated to: " + thresholdEvalResult);
        Result buildResult = build.getResult();
        if (buildResult == null) {
            log.log(Level.WARNING, "Build result is unavailable at this point.");
            this.outStream.println("Build result is unavailable at this point. Will not proceed.");
            return false;
        }
        if (!thresholdEvalResult && !buildResult.isWorseOrEqualTo(Result.FAILURE)) {
            build.setResult(Result.UNSTABLE);
        }
        if (qaReportSettings.isLoginToQAV() && qaReportSettings.isPublishToQAV()) {
            if (qaReportSettings.isQaUploadWhenStable() && buildResult.isWorseOrEqualTo(Result.UNSTABLE)) {
                this.outStream.println("Upload warning: QAV Upload cant be perform because build is Unstable");
                log.log(Level.WARNING, "UPLOAD WARNING - QAV Upload cant be perform because build is Unstable");
            } else {
                if (buildResult.isWorseOrEqualTo(Result.UNSTABLE)) {
                    this.outStream.println("Upload warning: Build is Unstable but upload will continue...");
                }
                this.outStream.println("Upload info: QAV Upload...");
                for (QAFrameworkRemoteReportUpload remoteReportUpload : remoteReportUploads) {
                    try {
                        this.performUpload(build, remoteToolCheck, remoteReportUpload);
                    }
                    catch (PrqaException ex) {
                        log.log(Level.SEVERE, ex.getMessage(), ex);
                        this.outStream.println(ex.getMessage());
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                }
            }
        }
        this.outStream.println("\n----------------------BUILD Results-----------------------\n");
        if (previousBuildResultTuple != null) {
            this.outStream.println(Messages.PRQANotifier_PreviousResultBuildNumber(((AbstractBuild)previousBuildResultTuple.getValue()).number));
            this.outStream.println(previousBuildResultTuple.getKey());
        } else {
            this.outStream.println(Messages.PRQANotifier_NoPreviousResults());
        }
        this.outStream.println(Messages.PRQANotifier_ScannedValues());
        this.outStream.println(currentBuild);
        PRQABuildAction action = new PRQABuildAction(build);
        action.setResult(currentBuild);
        action.setPublisher((Publisher)this);
        build.addAction((Action)action);
        return true;
    }

    private QaFrameworkReportSettings setQaFrameworkReportSettings(QAFrameworkPostBuildActionSetup qaFrameworkPostBuildActionSetup, AbstractBuild<?, ?> build, BuildListener listener) throws PrqaSetupException {
        if (qaFrameworkPostBuildActionSetup.qaProject == null) {
            throw new PrqaSetupException("Project configuration is missing. Please set a project in Qa Framework configuration section!");
        }
        return new QaFrameworkReportSettings(qaFrameworkPostBuildActionSetup.qaInstallation, qaFrameworkPostBuildActionSetup.useCustomLicenseServer, PRQABuildUtils.normalizeWithEnv(qaFrameworkPostBuildActionSetup.customLicenseServerAddress, build, (TaskListener)listener), PRQABuildUtils.normalizeWithEnv(qaFrameworkPostBuildActionSetup.qaProject, build, (TaskListener)listener), qaFrameworkPostBuildActionSetup.downloadUnifiedProjectDefinition, PRQABuildUtils.normalizeWithEnv(qaFrameworkPostBuildActionSetup.unifiedProjectName, build, (TaskListener)listener), qaFrameworkPostBuildActionSetup.enableDependencyMode, qaFrameworkPostBuildActionSetup.performCrossModuleAnalysis, PRQABuildUtils.normalizeWithEnv(qaFrameworkPostBuildActionSetup.cmaProjectName, build, (TaskListener)listener), qaFrameworkPostBuildActionSetup.reuseCmaDb, qaFrameworkPostBuildActionSetup.useDiskStorage, qaFrameworkPostBuildActionSetup.generateReport, qaFrameworkPostBuildActionSetup.publishToQAV, qaFrameworkPostBuildActionSetup.loginToQAV, qaFrameworkPostBuildActionSetup.uploadWhenStable, PRQABuildUtils.normalizeWithEnv(qaFrameworkPostBuildActionSetup.qaVerifyProjectName, build, (TaskListener)listener), PRQABuildUtils.normalizeWithEnv(qaFrameworkPostBuildActionSetup.uploadSnapshotName, build, (TaskListener)listener), Integer.toString(build.getNumber()), qaFrameworkPostBuildActionSetup.uploadSourceCode, qaFrameworkPostBuildActionSetup.generateCrr, qaFrameworkPostBuildActionSetup.generateMdr, qaFrameworkPostBuildActionSetup.generateSup, qaFrameworkPostBuildActionSetup.analysisSettings, qaFrameworkPostBuildActionSetup.stopWhenFail, qaFrameworkPostBuildActionSetup.customCpuThreads, qaFrameworkPostBuildActionSetup.maxNumThreads, qaFrameworkPostBuildActionSetup.generatePreprocess, qaFrameworkPostBuildActionSetup.assembleSupportAnalytics, qaFrameworkPostBuildActionSetup.generateReportOnAnalysisError, qaFrameworkPostBuildActionSetup.addBuildNumber, qaFrameworkPostBuildActionSetup.projectConfiguration);
    }

    private QAVerifyServerSettings setQaVerifyServerSettings(String configurationByName) {
        QAVerifyServerConfiguration qaVerifyServerConfiguration = PRQAGlobalConfig.get().getConfigurationByName(configurationByName);
        if (qaVerifyServerConfiguration != null) {
            return new QAVerifyServerSettings(qaVerifyServerConfiguration.getHostName(), qaVerifyServerConfiguration.getViewerPortNumber(), qaVerifyServerConfiguration.getProtocol(), qaVerifyServerConfiguration.getPassword(), qaVerifyServerConfiguration.getUserName());
        }
        return new QAVerifyServerSettings();
    }

    private PRQAComplianceStatus performBuild(AbstractBuild<?, ?> build, PRQARemoteToolCheck remoteToolCheck, QAFrameworkRemoteReport remoteReport, QaFrameworkReportSettings qaReportSettings, BuildListener listener) throws PrqaException, IOException {
        PRQAComplianceStatus currentBuild;
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IOException("Invalid workspace. Cannot continue.");
        }
        try {
            QaFrameworkVersion qaFrameworkVersion = new QaFrameworkVersion((String)workspace.act((FilePath.FileCallable)remoteToolCheck));
            if (!this.isQafVersionSupported(qaFrameworkVersion)) {
                throw new PrqaException("Build failure. Please upgrade to a newer version of PRQA Framework");
            }
            currentBuild = (PRQAComplianceStatus)workspace.act((FilePath.FileCallable)remoteReport);
            currentBuild.setMessagesWithinThresholdForEachMessageGroup(this.getThresholdLevel());
            this.copyArtifacts(build, qaReportSettings, listener);
        }
        catch (IOException | InterruptedException ex) {
            this.outStream.println(Messages.PRQANotifier_FailedGettingResults());
            throw new PrqaException(ex);
        }
        return currentBuild;
    }

    public int getThresholdLevel() {
        if (this.thresholdsDesc != null) {
            for (AbstractThreshold abstractThreshold : this.thresholdsDesc) {
                if (!(abstractThreshold instanceof MessageComplianceThreshold)) continue;
                return ((MessageComplianceThreshold)abstractThreshold).thresholdLevel;
            }
        }
        return 0;
    }

    private void performUpload(AbstractBuild<?, ?> build, PRQARemoteToolCheck remoteToolCheck, QAFrameworkRemoteReportUpload remoteReportUpload) throws PrqaException, IOException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IOException("Invalid workspace. Cannot continue.");
        }
        try {
            QaFrameworkVersion qaFrameworkVersion = new QaFrameworkVersion((String)workspace.act((FilePath.FileCallable)remoteToolCheck));
            if (!this.isQafVersionSupported(qaFrameworkVersion)) {
                throw new PrqaException("Build failure. Please upgrade to a newer version of PRQA Framework");
            }
            workspace.act((FilePath.FileCallable)remoteReportUpload);
        }
        catch (IOException | InterruptedException ex) {
            throw new PrqaException(ex);
        }
    }

    private boolean isQafVersionSupported(QaFrameworkVersion qaFrameworkVersion) {
        this.outStream.println(String.format("PRQA Source Code Analysis Framework version %s", qaFrameworkVersion.getQaFrameworkVersion()));
        if (!qaFrameworkVersion.isVersionSupported()) {
            this.outStream.println(String.format("ERROR: In order to use the PRQA plugin please install a version of PRQA Framework greater or equal to %s!", "2.2.0"));
            return false;
        }
        return true;
    }

    private void copyArtifacts(AbstractBuild<?, ?> build, QaFrameworkReportSettings qaReportSettings, BuildListener listener) {
        try {
            this.copyReportsToArtifactsDir(qaReportSettings, build, listener);
            if (qaReportSettings.isPublishToQAV() && qaReportSettings.isLoginToQAV()) {
                this.copyResourcesToArtifactsDir("*.log", build, listener);
            }
        }
        catch (IOException | InterruptedException ex) {
            log.log(Level.SEVERE, "Failed copying build artifacts from slave to server - Use Copy Artifact Plugin", ex);
            this.outStream.println("Auto Copy of Build Artifacts to artifact dir on Master Failed");
            this.outStream.println("Manually add Build Artifacts to artifact dir or use Copy Artifact Plugin ");
            this.outStream.println(ex.getMessage());
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public List<ThresholdSelectionDescriptor<?>> getThresholdSelections() {
            return AbstractThreshold.getDescriptors();
        }

        public String getDisplayName() {
            return "Programming Research Report";
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, @Nonnull JSONObject formData) throws Descriptor.FormException {
            if (req == null) {
                throw new Descriptor.FormException((Throwable)new Exception("Bad request"), "Bad request");
            }
            String SOURCE_QA_FRAMEWORK = "sourceQAFramework";
            String CODE_REVIEW_REPORT = "generateCrr";
            String SUPPRESSION_REPORT = "generateSup";
            PRQANotifier instance = (PRQANotifier)req.bindJSON(PRQANotifier.class, formData);
            instance.setChosenReportTypes((EnumSet<PRQAContext.QARReportType>)PRQAContext.QARReportType.REQUIRED_TYPES.clone());
            if (formData.containsKey((Object)"sourceQAFramework")) {
                JSONObject sourceObject = formData.getJSONObject("sourceQAFramework");
                if (sourceObject.getBoolean("generateCrr")) {
                    instance.chosenReportTypes.add(PRQAContext.QARReportType.CodeReview);
                }
                if (sourceObject.getBoolean("generateSup")) {
                    instance.chosenReportTypes.add(PRQAContext.QARReportType.Suppression);
                }
            }
            if (CollectionUtils.isEmpty(instance.getGraphTypes())) {
                ArrayList<PRQAGraph> list = new ArrayList<PRQAGraph>();
                list.add(new ComplianceIndexGraphs());
                list.add(new MessagesGraph());
                instance.setGraphTypes(list);
            }
            this.save();
            return instance;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        public DescriptorImpl() {
            super(PRQANotifier.class);
            this.load();
        }

        public List<QAFrameworkInstallationConfiguration> getQaFrameworkTools() {
            Jenkins jenkins = Jenkins.get();
            QAFrameworkInstallationConfiguration[] prqaInstallations = (QAFrameworkInstallationConfiguration[])((QAFrameworkInstallationConfiguration.DescriptorImpl)jenkins.getDescriptorByType(QAFrameworkInstallationConfiguration.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(prqaInstallations);
        }

        public List<PRQAReportSourceDescriptor<?>> getReportSources() {
            return PostBuildActionSetup.getDescriptors();
        }

        public PRQAReportSourceDescriptor<?> getReportSource() {
            return PostBuildActionSetup.getDescriptors().get(0);
        }
    }
}

