/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jpowershell;

import com.profesorfalken.jpowershell.PowerShellCommandProcessor;
import com.profesorfalken.jpowershell.PowerShellConfig;
import com.profesorfalken.jpowershell.PowerShellNotAvailableException;
import com.profesorfalken.jpowershell.PowerShellResponse;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerShell {
    private Process p;
    private PrintWriter commandWriter;
    private boolean closed = false;
    private ExecutorService threadpool;
    private int maxThreads = 3;
    private int waitPause = 10;
    private long maxWait = 10000L;
    private boolean scriptMode = false;
    public static final String END_SCRIPT_STRING = "--END-JPOWERSHELL-SCRIPT--";

    private PowerShell() {
    }

    public PowerShell configuration(Map<String, String> config) {
        try {
            this.maxThreads = Integer.valueOf(config != null && config.get("maxThreads") != null ? config.get("maxThreads") : PowerShellConfig.getConfig().getProperty("maxThreads"));
            this.waitPause = Integer.valueOf(config != null && config.get("waitPause") != null ? config.get("waitPause") : PowerShellConfig.getConfig().getProperty("waitPause"));
            this.maxWait = Long.valueOf(config != null && config.get("maxWait") != null ? config.get("maxWait") : PowerShellConfig.getConfig().getProperty("maxWait"));
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Could not read configuration. Use default values.", nfe);
        }
        return this;
    }

    private PowerShell initalize() throws PowerShellNotAvailableException {
        ProcessBuilder pb = new ProcessBuilder("powershell.exe", "-NoExit", "-Command", "-");
        try {
            this.p = pb.start();
        }
        catch (IOException ex) {
            throw new PowerShellNotAvailableException("Cannot execute PowerShell.exe. Please make sure that it is installed in your system", ex);
        }
        this.commandWriter = new PrintWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(this.p.getOutputStream())), true);
        this.threadpool = Executors.newFixedThreadPool(this.maxThreads);
        return this;
    }

    public static PowerShell openSession() throws PowerShellNotAvailableException {
        PowerShell powerShell = new PowerShell();
        powerShell.configuration(null);
        return powerShell.initalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerShellResponse executeCommand(String command) {
        PowerShellCommandProcessor commandProcessor = new PowerShellCommandProcessor("standard", this.p.getInputStream(), this.maxWait, this.waitPause, this.scriptMode);
        PowerShellCommandProcessor commandProcessorError = new PowerShellCommandProcessor("error", this.p.getErrorStream(), this.maxWait, this.waitPause, false);
        String commandOutput = "";
        boolean isError = false;
        boolean timeout = false;
        Future<String> result = this.threadpool.submit(commandProcessor);
        Future<String> resultError = this.threadpool.submit(commandProcessorError);
        this.commandWriter.println(command);
        try {
            while (!result.isDone() && !resultError.isDone()) {
                Thread.sleep(this.waitPause);
            }
            if (result.isDone()) {
                if (commandProcessor.isTimeout()) {
                    timeout = true;
                } else {
                    commandOutput = result.get();
                }
            } else {
                isError = true;
                commandOutput = resultError.get();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
        }
        finally {
            commandProcessor.close();
            commandProcessorError.close();
        }
        return new PowerShellResponse(isError, commandOutput, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PowerShellResponse executeSingleCommand(String command) {
        PowerShell session = null;
        PowerShellResponse response = null;
        try {
            session = PowerShell.openSession();
            response = session.executeCommand(command);
        }
        catch (PowerShellNotAvailableException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "PowerShell not available", ex);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return response;
    }

    public PowerShellResponse executeScript(String scriptPath) {
        return this.executeScript(scriptPath, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerShellResponse executeScript(String scriptPath, String params) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        File tmpFile = null;
        try {
            String line;
            File scriptToExecute = new File(scriptPath);
            if (!scriptToExecute.exists()) {
                PowerShellResponse powerShellResponse = new PowerShellResponse(true, "Wrong script path: " + scriptToExecute, false);
                return powerShellResponse;
            }
            tmpFile = File.createTempFile("psscript_" + new Date().getTime(), ".ps1");
            if (tmpFile == null || !tmpFile.exists()) {
                PowerShellResponse powerShellResponse = new PowerShellResponse(true, "Cannot create temp script file", false);
                return powerShellResponse;
            }
            reader = new BufferedReader(new FileReader(scriptToExecute));
            writer = new BufferedWriter(new FileWriter(tmpFile));
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
            writer.write("Write-Host \"--END-JPOWERSHELL-SCRIPT--\"");
        }
        catch (FileNotFoundException fnfex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell script", fnfex);
        }
        catch (IOException ioex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell script", ioex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell script", ex);
            }
        }
        this.scriptMode = true;
        return this.executeCommand(tmpFile.getAbsolutePath() + " " + params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        block18: {
            if (!this.closed) {
                Future<String> closeTask = this.threadpool.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        PowerShell.this.commandWriter.println("exit");
                        PowerShell.this.p.waitFor();
                        return "OK";
                    }
                });
                this.waitUntilClose(closeTask);
                Object var3_3 = null;
                try {
                    this.p.getInputStream().close();
                    this.p.getErrorStream().close();
                }
                catch (IOException ex2) {
                    Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing streams", ex2);
                }
                this.commandWriter.close();
                if (this.threadpool != null) {
                    try {
                        this.threadpool.shutdownNow();
                        this.threadpool.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException ex2) {
                        Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when shutting thread pool", ex2);
                    }
                }
                this.closed = true;
                {
                    break block18;
                    catch (InterruptedException ex) {
                        Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing PowerShell", ex);
                        Object var3_4 = null;
                        try {
                            this.p.getInputStream().close();
                            this.p.getErrorStream().close();
                        }
                        catch (IOException ex2) {
                            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing streams", ex2);
                        }
                        this.commandWriter.close();
                        if (this.threadpool != null) {
                            try {
                                this.threadpool.shutdownNow();
                                this.threadpool.awaitTermination(5L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ex2) {
                                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when shutting thread pool", ex2);
                            }
                        }
                        this.closed = true;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    try {
                        this.p.getInputStream().close();
                        this.p.getErrorStream().close();
                    }
                    catch (IOException ex2) {
                        Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing streams", ex2);
                    }
                    this.commandWriter.close();
                    if (this.threadpool != null) {
                        try {
                            this.threadpool.shutdownNow();
                            this.threadpool.awaitTermination(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException ex2) {
                            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when shutting thread pool", ex2);
                        }
                    }
                    this.closed = true;
                    throw throwable;
                }
            }
        }
    }

    private void waitUntilClose(Future<String> task) throws InterruptedException {
        int closingTime = 0;
        while (!task.isDone()) {
            if ((long)closingTime > this.maxWait) {
                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when closing PowerShell: TIMEOUT!");
                break;
            }
            Thread.sleep(this.waitPause);
            closingTime += this.waitPause;
        }
    }
}

