/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.wmi4java;

import com.google.common.base.Joiner;
import com.profesorfalken.jpowershell.PowerShell;
import com.profesorfalken.jpowershell.PowerShellNotAvailableException;
import com.profesorfalken.jpowershell.PowerShellResponse;
import com.profesorfalken.wmi4java.WMIException;
import com.profesorfalken.wmi4java.WMIStub;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WMIPowerShell
implements WMIStub {
    private static final String NAMESPACE_PARAM = "-Namespace ";
    private static final String GETWMIOBJECT_COMMAND = "Get-WMIObject ";

    WMIPowerShell() {
    }

    private static String executeCommand(String command) throws WMIException {
        String commandResponse = null;
        PowerShell powerShell = null;
        try {
            powerShell = PowerShell.openSession();
            PowerShellResponse psResponse = powerShell.executeCommand(command);
            if (psResponse.isError()) {
                throw new WMIException("WMI operation finished in error: " + psResponse.getCommandOutput());
            }
            commandResponse = psResponse.getCommandOutput().trim();
            powerShell.close();
        }
        catch (PowerShellNotAvailableException ex) {
            throw new WMIException(ex.getMessage(), ex);
        }
        finally {
            if (powerShell != null) {
                powerShell.close();
            }
        }
        return commandResponse;
    }

    @Override
    public String listClasses(String namespace, String computerName) throws WMIException {
        String namespaceString = "";
        if (!"*".equals(namespace)) {
            namespaceString = namespaceString + NAMESPACE_PARAM + namespace;
        }
        return WMIPowerShell.executeCommand(GETWMIOBJECT_COMMAND + namespaceString + " -List | Sort Name");
    }

    @Override
    public String listProperties(String wmiClass, String namespace, String computerName) throws WMIException {
        String command = GETWMIOBJECT_COMMAND + wmiClass + " ";
        if (!"*".equals(namespace)) {
            command = command + NAMESPACE_PARAM + namespace;
        }
        command = command + " | ";
        command = command + "Select-Object * -excludeproperty \"_*\" | ";
        command = command + "Get-Member | select name | format-table -hidetableheader";
        return WMIPowerShell.executeCommand(command);
    }

    @Override
    public String listObject(String wmiClass, String namespace, String computerName) throws WMIException {
        String command = GETWMIOBJECT_COMMAND + wmiClass + " ";
        if (!"*".equals(namespace)) {
            command = command + NAMESPACE_PARAM + namespace;
        }
        command = command + " | ";
        command = command + "Select-Object * -excludeproperty \"_*\" | ";
        command = command + "Format-List *";
        return WMIPowerShell.executeCommand(command);
    }

    @Override
    public String queryObject(String wmiClass, List<String> wmiProperties, List<String> conditions, String namespace, String computerName) throws WMIException {
        String command = GETWMIOBJECT_COMMAND + wmiClass + " ";
        if (!"*".equals(namespace)) {
            command = command + NAMESPACE_PARAM + namespace;
        }
        List<String> usedWMIProperties = wmiProperties == null || wmiProperties.isEmpty() ? Collections.singletonList("*") : wmiProperties;
        command = command + " | ";
        command = command + "Select-Object " + Joiner.on((String)", ").join(usedWMIProperties) + " -excludeproperty \"_*\" | ";
        if (conditions != null && !conditions.isEmpty()) {
            for (String condition : conditions) {
                command = command + "Where-Object -FilterScript {" + condition + "} | ";
            }
        }
        command = command + "Format-List *";
        return WMIPowerShell.executeCommand(command);
    }
}

