/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.priyankvex.smarttextview;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.wordpress.priyankvex.smarttextview.SmartTextCallback;

public class SmartTextView
extends TextView {
    private Context mContext;
    private String mEmailColorCode;
    private String mUrlColorCode;
    private String mPhoneNumberColorCode;
    private String mMentionColorCode;
    private String mHashTagColorCode;
    private SmartTextCallback mSmartTextCallback;
    private boolean detectMentions = false;
    private boolean detectHashTags = false;

    public SmartTextView(Context context) {
        super(context);
        this.mContext = context;
    }

    public SmartTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mEmailColorCode = "#3344ff";
        this.mUrlColorCode = "#3344ff";
        this.mPhoneNumberColorCode = "#3344ff";
        this.mMentionColorCode = "#3344ff";
        this.mHashTagColorCode = "#3344ff";
    }

    public void setText(String text) {
        String[] words;
        super.setText((CharSequence)text);
        Log.d((String)"test", (String)"Custom set text");
        SpannableString ss = new SpannableString((CharSequence)text);
        for (String word : words = text.split(" ")) {
            int endIndex;
            int startIndex;
            Log.d((String)"test", (String)word);
            word = word.replace("\n", "");
            if (word.matches("^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$")) {
                startIndex = text.indexOf(word);
                endIndex = startIndex + word.length();
                final String finalWord = word;
                ClickableSpan emailClickSpan = new ClickableSpan(){

                    public void onClick(View widget) {
                        if (SmartTextView.this.mSmartTextCallback == null) {
                            Intent emailIntent = new Intent("android.intent.action.SENDTO", Uri.fromParts((String)"mailto", (String)finalWord, null));
                            SmartTextView.this.mContext.startActivity(Intent.createChooser((Intent)emailIntent, (CharSequence)"Send Email"));
                        } else {
                            SmartTextView.this.mSmartTextCallback.emailClick(finalWord);
                        }
                    }
                };
                ForegroundColorSpan emailColorSpan = new ForegroundColorSpan(Color.parseColor((String)this.mEmailColorCode));
                ss.setSpan((Object)emailClickSpan, startIndex, endIndex, 33);
                ss.setSpan((Object)emailColorSpan, startIndex, endIndex, 33);
                Log.d((String)"test", (String)("Email matched" + startIndex + " : " + endIndex));
                continue;
            }
            if (word.matches("(http:\\/\\/|https:\\/\\/|www.).{3,}")) {
                startIndex = text.indexOf(word);
                endIndex = startIndex + word.length();
                final String finalWord1 = word.startsWith("http://") || word.startsWith("https://") ? word : "http://" + word;
                ClickableSpan urlClickSpan = new ClickableSpan(){

                    public void onClick(View widget) {
                        if (SmartTextView.this.mSmartTextCallback == null) {
                            Intent i = new Intent("android.intent.action.VIEW");
                            i.setData(Uri.parse((String)finalWord1));
                            SmartTextView.this.mContext.startActivity(i);
                        } else {
                            SmartTextView.this.mSmartTextCallback.webUrlClick(finalWord1);
                        }
                    }
                };
                ForegroundColorSpan urlColorSpan = new ForegroundColorSpan(Color.parseColor((String)this.mUrlColorCode));
                ss.setSpan((Object)urlClickSpan, startIndex, endIndex, 33);
                ss.setSpan((Object)urlColorSpan, startIndex, endIndex, 33);
                Log.d((String)"test", (String)("Url matched" + startIndex + " : " + endIndex));
                continue;
            }
            if (word.matches("\\b\\d{3}[-.]?\\d{3}[-.]?\\d{4}\\b")) {
                startIndex = text.indexOf(word);
                endIndex = startIndex + word.length();
                final String finalWord2 = word;
                ClickableSpan numberClickSpan = new ClickableSpan(){

                    public void onClick(View widget) {
                        if (SmartTextView.this.mSmartTextCallback == null) {
                            Intent intent = new Intent("android.intent.action.DIAL");
                            intent.setData(Uri.parse((String)("tel:" + finalWord2)));
                            SmartTextView.this.mContext.startActivity(intent);
                        } else {
                            SmartTextView.this.mSmartTextCallback.phoneNumberClick(finalWord2);
                        }
                    }
                };
                ForegroundColorSpan numberColorSpan = new ForegroundColorSpan(Color.parseColor((String)this.mPhoneNumberColorCode));
                ss.setSpan((Object)numberClickSpan, startIndex, endIndex, 33);
                ss.setSpan((Object)numberColorSpan, startIndex, endIndex, 33);
                Log.d((String)"test", (String)("Phone Number matched" + startIndex + " : " + endIndex));
                continue;
            }
            if (this.detectMentions && word.startsWith("@") && word.length() >= 2) {
                startIndex = text.indexOf(word);
                endIndex = startIndex + word.length();
                final String finalWord3 = word;
                ClickableSpan mentionClickSpan = new ClickableSpan(){

                    public void onClick(View widget) {
                        if (SmartTextView.this.mSmartTextCallback == null) {
                            Log.e((String)"test", (String)"Implement SmartTextCallback and set setSmartTextCallback(this) in your activity/fragment");
                        } else {
                            SmartTextView.this.mSmartTextCallback.mentionClick(finalWord3);
                        }
                    }
                };
                ForegroundColorSpan mentionColorSpan = new ForegroundColorSpan(Color.parseColor((String)this.mMentionColorCode));
                ss.setSpan((Object)mentionClickSpan, startIndex, endIndex, 33);
                ss.setSpan((Object)mentionColorSpan, startIndex, endIndex, 33);
                Log.d((String)"test", (String)("Mention matched" + startIndex + " : " + endIndex));
                continue;
            }
            if (!this.detectHashTags || !word.startsWith("#") || word.length() < 2) continue;
            startIndex = text.indexOf(word);
            endIndex = startIndex + word.length();
            final String finalWord4 = word;
            ClickableSpan hashTagClickSpan = new ClickableSpan(){

                public void onClick(View widget) {
                    if (SmartTextView.this.mSmartTextCallback == null) {
                        Log.e((String)"test", (String)"Implement SmartTextCallback and set setSmartTextCallback(this) in your activity/fragment");
                    } else {
                        SmartTextView.this.mSmartTextCallback.hashTagClick(finalWord4);
                    }
                }
            };
            ForegroundColorSpan hashTagColorSpan = new ForegroundColorSpan(Color.parseColor((String)this.mHashTagColorCode));
            ss.setSpan((Object)hashTagClickSpan, startIndex, endIndex, 33);
            ss.setSpan((Object)hashTagColorSpan, startIndex, endIndex, 33);
            Log.d((String)"test", (String)("Hash tag matched" + startIndex + " : " + endIndex));
        }
        super.setText((CharSequence)ss);
        super.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public void setEmailColorCode(String emailColorCode) {
        this.mEmailColorCode = emailColorCode;
    }

    public void setUrlColorCode(String urlColorCode) {
        this.mUrlColorCode = urlColorCode;
    }

    public void setPhoneNumberColorCode(String phoneNumberColorCode) {
        this.mPhoneNumberColorCode = phoneNumberColorCode;
    }

    public void setHashTagColorCode(String hashTagColorCode) {
        this.mHashTagColorCode = hashTagColorCode;
    }

    public void setMentionColorCode(String mentionColorCode) {
        this.mMentionColorCode = mentionColorCode;
    }

    public void setSmartTextCallback(SmartTextCallback mSmartTextCallback) {
        this.mSmartTextCallback = mSmartTextCallback;
    }

    public void setDetectMentions(boolean value) {
        this.detectMentions = value;
    }

    public void setDetectHashTags(boolean value) {
        this.detectHashTags = value;
    }
}

