/*
 * Decompiled with CFR 0.152.
 */
package com.premiumminds.webapp.utils.mailer;

import com.premiumminds.webapp.utils.WebAppFileLoader;
import com.premiumminds.webapp.utils.mailer.AbstractMailer;
import com.premiumminds.webapp.utils.mailer.Mailer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextMailerListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(ContextMailerListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        String url = context.getInitParameter("mailer-config");
        if (url == null) {
            throw new RuntimeException("couldn't get webapp parameter 'mailer-config'");
        }
        WebAppFileLoader fileLoader = new WebAppFileLoader(url, sce.getServletContext());
        try {
            Mailer.configure(fileLoader.load());
            AbstractMailer.configure(fileLoader.load());
        }
        catch (Exception e) {
            log.error("couldn't load the Mailer properties on '" + url + "'", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

