/*
 * Decompiled with CFR 0.152.
 */
package com.premiumminds.webapp.utils.mailer;

import com.premiumminds.webapp.utils.mailer.MailerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailer {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private static final Logger log = LoggerFactory.getLogger(AbstractMailer.class);
    private static Properties mailConfig;

    protected static String getConfigurationProperty(String key) {
        return mailConfig.getProperty(key);
    }

    protected static String getConfigurationProperty(String key, String defaultValue) {
        String value = mailConfig.getProperty(key);
        return value == null ? defaultValue : value;
    }

    protected static Properties getConfiguration() {
        return mailConfig;
    }

    public static final void configure(InputStream input) throws IOException {
        Properties properties = new Properties();
        properties.load(input);
        AbstractMailer.configure(properties);
    }

    public static final void configure(Properties properties) throws IOException {
        if (AbstractMailer.isValidBasicConfiguration(properties)) {
            mailConfig = properties;
        } else {
            log.error("The mailer basic configuration is not valid");
        }
    }

    public final boolean isDebug() {
        String debug = AbstractMailer.getConfigurationProperty("mail.debug");
        return new String("true").equalsIgnoreCase(debug);
    }

    public final String getDebugAddress() {
        String debugAddress = AbstractMailer.getConfigurationProperty("mail.debug.to");
        return debugAddress;
    }

    protected static InternetAddress convertStringToAddress(String mail) throws MailerException {
        try {
            return new InternetAddress(mail);
        }
        catch (AddressException e) {
            throw new MailerException(e);
        }
    }

    protected static Collection<InternetAddress> convertStringsToAddressess(Collection<String> mails) throws MailerException {
        ArrayList<InternetAddress> to = new ArrayList<InternetAddress>();
        if (mails != null) {
            for (String mail : mails) {
                to.add(AbstractMailer.convertStringToAddress(mail));
            }
        }
        return to;
    }

    public static List<String> getList(String value) {
        String[] values = value.isEmpty() ? new String[]{} : value.split(";");
        return Arrays.asList(values);
    }

    protected final boolean isValidConfiguration(Properties config) {
        return AbstractMailer.isValidBasicConfiguration(config) && this.isValidMailerConfiguration(config);
    }

    protected static final boolean isValidBasicConfiguration(Properties config) {
        return config != null && config.getProperty("mail.smtp.auth") != null && config.getProperty("mail.smtp.user") != null && config.getProperty("mail.smtp.password") != null;
    }

    public static final boolean isValidEmail(String email) {
        return EMAIL_PATTERN.matcher(email).matches();
    }

    protected abstract boolean isValidMailerConfiguration(Properties var1);

    public abstract void send(MimeMessage var1) throws MailerException;

    public abstract void send(String var1, String var2, String var3) throws MailerException;

    public abstract void send(String var1, Map<String, String> var2, String var3, String var4) throws MailerException;

    public abstract void send(Collection<String> var1, Collection<String> var2, Collection<String> var3, String var4, String var5) throws MailerException;

    public abstract void send(Collection<String> var1, Collection<String> var2, Collection<String> var3, Map<String, String> var4, String var5, String var6) throws MailerException;

    protected static class Configuration {
        public static final String NAMESPACE = "mail";

        protected Configuration() {
        }

        public static class Debug {
            public static final String NAMESPACE = "mail.debug";
            public static final String DEBUG_ADDRESS = "mail.debug.to";
        }

        public static class SMTP {
            public static final String NAMESPACE = "mail.smtp";
            public static final String HOST = "mail.smtp.auth";
            public static final String USER = "mail.smtp.user";
            public static final String PASSWORD = "mail.smtp.password";
            public static final String AUTH = "mail.smtp.auth";
            public static final String FROM = "mail.smtp.from";
        }
    }
}

