/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.loader.handler;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;

public class ImageViewHandler
extends Handler {
    private final WeakReference<ImageView> mImageView;

    public ImageViewHandler(@Nullable ImageView imageView) {
        super(Looper.getMainLooper());
        this.mImageView = new WeakReference<ImageView>(imageView);
    }

    public void handleMessage(@NonNull Message msg) {
        super.handleMessage(msg);
        if (this.getImageView() == null) {
            return;
        }
        if (msg.obj instanceof Drawable) {
            this.getImageView().setImageDrawable((Drawable)msg.obj);
        } else if (msg.obj instanceof Bitmap) {
            this.getImageView().setImageBitmap((Bitmap)msg.obj);
        } else {
            this.getImageView().setImageDrawable(msg.what == 3 ? null : this.getImageView().getDrawable());
        }
    }

    @Nullable
    public ImageView getImageView() {
        if (this.mImageView == null) {
            return null;
        }
        return (ImageView)this.mImageView.get();
    }
}

