/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import android.widget.TextSwitcher;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.Insets;
import androidx.core.text.HtmlCompat;
import androidx.core.text.TextUtilsCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import com.pranavpandey.android.dynamic.util.DynamicSdkUtils;
import java.util.Locale;

public class DynamicViewUtils {
    public static <T extends View> boolean isRootLayout(@Nullable T view) {
        return view != null && !(view.getParent() instanceof View);
    }

    @TargetApi(value=23)
    public static void setEdgeToEdge(@Nullable View view, boolean edgeToEdge) {
        if (view == null) {
            return;
        }
        if (DynamicSdkUtils.is23()) {
            int flags = view.getSystemUiVisibility();
            if (edgeToEdge) {
                flags |= 0x100;
                flags |= 0x200;
                flags |= 0x400;
            } else {
                flags &= 0xFFFFFEFF;
                flags &= 0xFFFFFDFF;
                flags &= 0xFFFFFBFF;
            }
            view.setSystemUiVisibility(flags);
        }
    }

    @TargetApi(value=23)
    public static boolean isEdgeToEdge(@NonNull View view) {
        if (DynamicSdkUtils.is23()) {
            int flags = view.getSystemUiVisibility();
            return (flags & 0x100) == 0 && (flags & 0x200) == 0;
        }
        return false;
    }

    @TargetApi(value=23)
    public static void setLightStatusBar(@Nullable View view, boolean light) {
        if (view == null) {
            return;
        }
        if (DynamicSdkUtils.is30()) {
            WindowInsetsControllerCompat controller = ViewCompat.getWindowInsetsController((View)view);
            if (controller != null) {
                controller.setAppearanceLightStatusBars(light);
            }
        } else if (DynamicSdkUtils.is23()) {
            int flags = view.getSystemUiVisibility();
            flags = light ? (flags |= 0x2000) : (flags &= 0xFFFFDFFF);
            view.setSystemUiVisibility(flags);
        }
    }

    @TargetApi(value=26)
    public static void setLightNavigationBar(@Nullable View view, boolean light) {
        if (view == null) {
            return;
        }
        if (DynamicSdkUtils.is30()) {
            WindowInsetsControllerCompat controller = ViewCompat.getWindowInsetsController((View)view);
            if (controller != null) {
                controller.setAppearanceLightNavigationBars(light);
            }
        } else if (DynamicSdkUtils.is26()) {
            int flags = view.getSystemUiVisibility();
            flags = light ? (flags |= 0x10) : (flags &= 0xFFFFFFEF);
            view.setSystemUiVisibility(flags);
        }
    }

    public static void addView(@Nullable ViewGroup viewGroup, @Nullable View view, boolean removePrevious) {
        if (viewGroup == null) {
            return;
        }
        if (removePrevious && viewGroup.getChildCount() > 0) {
            viewGroup.removeAllViews();
        }
        if (view != null) {
            viewGroup.addView(view);
        }
    }

    public static void addView(@Nullable ViewGroup viewGroup, @LayoutRes int layoutRes, boolean removePrevious) {
        if (viewGroup != null) {
            DynamicViewUtils.addView(viewGroup, LayoutInflater.from((Context)viewGroup.getContext()).inflate(layoutRes, viewGroup, false), removePrevious);
        }
    }

    public static void manageScrollIndicators(@Nullable View view, @Nullable View upIndicator, @Nullable View downIndicator) {
        if (view == null || upIndicator == null && downIndicator == null) {
            return;
        }
        if (upIndicator != null) {
            upIndicator.setVisibility(view.canScrollVertically(-1) ? 0 : 4);
        }
        if (downIndicator != null) {
            downIndicator.setVisibility(view.canScrollVertically(1) ? 0 : 4);
        }
    }

    public static boolean isLayoutRtl(@Nullable View view) {
        if (view == null) {
            return TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
        }
        return ViewCompat.getLayoutDirection((View)view) == 1;
    }

    public static void applyWindowInsets(@Nullable View view, final boolean left, final boolean top, final boolean right, final boolean bottom, final boolean consume) {
        if (view == null) {
            return;
        }
        final int paddingLeft = view.getPaddingLeft();
        final int paddingTop = view.getPaddingTop();
        final int paddingRight = view.getPaddingRight();
        final int paddingBottom = view.getPaddingBottom();
        ViewCompat.setOnApplyWindowInsetsListener((View)view, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                boolean isRtl = DynamicViewUtils.isLayoutRtl(v);
                v.setPadding(left ? (isRtl ? paddingRight : paddingLeft + insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).left) : paddingLeft, top ? paddingTop + insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).top : paddingTop, right ? (isRtl ? paddingLeft : paddingRight + insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).right) : paddingRight, bottom ? paddingBottom + insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).bottom : paddingBottom);
                return !consume ? insets : new WindowInsetsCompat.Builder(insets).setInsets(WindowInsetsCompat.Type.systemBars(), Insets.of((int)(left ? 0 : insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).left), (int)(top ? 0 : insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).top), (int)(right ? 0 : insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).right), (int)(bottom ? 0 : insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).bottom))).build();
            }
        });
        DynamicViewUtils.requestApplyWindowInsets(view);
    }

    public static void applyWindowInsetsHorizontal(@Nullable View view, boolean consume) {
        DynamicViewUtils.applyWindowInsets(view, true, false, true, false, consume);
    }

    public static void applyWindowInsetsVertical(@Nullable View view, boolean consume) {
        DynamicViewUtils.applyWindowInsets(view, false, true, false, true, consume);
    }

    public static void applyWindowInsetsBottom(@Nullable View view, boolean consume) {
        DynamicViewUtils.applyWindowInsets(view, false, false, false, true, consume);
    }

    public static void applyWindowInsetsBottom(@Nullable View view) {
        DynamicViewUtils.applyWindowInsetsBottom(view, false);
    }

    public static void applyWindowInsetsHorizontalBottom(@Nullable View view, boolean consume) {
        DynamicViewUtils.applyWindowInsets(view, true, false, true, true, consume);
    }

    public static void applyWindowInsetsHorizontalBottom(@Nullable View view) {
        DynamicViewUtils.applyWindowInsetsHorizontalBottom(view, false);
    }

    public static void applyWindowInsetsMargin(final @Nullable View view, final boolean left, final boolean top, final boolean right, final boolean bottom, final boolean consume) {
        if (view == null || !(view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
            return;
        }
        final ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        final int leftMargin = layoutParams.leftMargin;
        final int topMargin = layoutParams.topMargin;
        final int rightMargin = layoutParams.rightMargin;
        final int bottomMargin = layoutParams.bottomMargin;
        ViewCompat.setOnApplyWindowInsetsListener((View)view, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                boolean isRtl = DynamicViewUtils.isLayoutRtl(v);
                if (left) {
                    int n = layoutParams.leftMargin = isRtl ? rightMargin : leftMargin + insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).left;
                }
                if (top) {
                    layoutParams.topMargin = topMargin + insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).top;
                }
                if (right) {
                    int n = layoutParams.rightMargin = isRtl ? leftMargin : rightMargin + insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).right;
                }
                if (bottom) {
                    layoutParams.bottomMargin = bottomMargin + insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).bottom;
                }
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                return !consume ? insets : new WindowInsetsCompat.Builder(insets).setInsets(WindowInsetsCompat.Type.systemBars(), Insets.of((int)(left ? 0 : insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).left), (int)(top ? 0 : insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).top), (int)(right ? 0 : insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).right), (int)(bottom ? 0 : insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).bottom))).build();
            }
        });
        DynamicViewUtils.requestApplyWindowInsets(view);
    }

    public static void applyWindowInsetsMarginHorizontal(@Nullable View view, boolean consume) {
        DynamicViewUtils.applyWindowInsetsMargin(view, true, false, true, false, consume);
    }

    public static void applyWindowInsetsMarginVertical(@Nullable View view, boolean consume) {
        DynamicViewUtils.applyWindowInsetsMargin(view, false, true, false, true, consume);
    }

    public static void applyWindowInsetsMarginBottom(@Nullable View view) {
        DynamicViewUtils.applyWindowInsetsMargin(view, false, false, false, true, false);
    }

    public static void applyWindowInsetsMarginHorizontalBottom(@Nullable View view) {
        DynamicViewUtils.applyWindowInsetsMargin(view, true, false, true, true, false);
    }

    public static void requestApplyWindowInsets(@Nullable View view) {
        if (view == null) {
            return;
        }
        if (ViewCompat.isAttachedToWindow((View)view)) {
            ViewCompat.requestApplyInsets((View)view);
        } else {
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View view) {
                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewCompat.requestApplyInsets((View)view);
                }

                public void onViewDetachedFromWindow(View view) {
                }
            });
        }
    }

    public static void setTextSwitcherText(@Nullable TextSwitcher view, @Nullable CharSequence text) {
        if (view == null || !(view.getCurrentView() instanceof TextView)) {
            return;
        }
        if (((TextView)view.getCurrentView()).getText() != null && ((TextView)view.getCurrentView()).getText().equals(text)) {
            view.setCurrentText(text);
        } else {
            view.setText(text);
        }
    }

    @TargetApi(value=16)
    public static void setTextViewTextSize(@Nullable RemoteViews remoteViews, @IdRes int viewId, int units, float size) {
        if (remoteViews == null) {
            return;
        }
        if (DynamicSdkUtils.is16()) {
            remoteViews.setTextViewTextSize(viewId, units, size);
        } else {
            remoteViews.setFloat(viewId, "setTextSize", size);
        }
    }

    public static void setTextViewMaxLines(@Nullable RemoteViews remoteViews, @IdRes int viewId, int lines) {
        if (remoteViews == null) {
            return;
        }
        remoteViews.setInt(viewId, "setMaxLines", lines);
    }

    public static void setTextViewText(@Nullable RemoteViews remoteViews, @IdRes int viewId, @Nullable CharSequence text, boolean visible) {
        if (remoteViews == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)text)) {
            remoteViews.setTextViewText(viewId, text);
            if (visible) {
                remoteViews.setViewVisibility(viewId, 0);
            }
        } else {
            remoteViews.setViewVisibility(viewId, 8);
        }
    }

    public static void setTextViewText(@Nullable RemoteViews remoteViews, @IdRes int viewId, @Nullable CharSequence text) {
        DynamicViewUtils.setTextViewText(remoteViews, viewId, text, true);
    }

    public static void setTextViewTextHtml(@Nullable RemoteViews remoteViews, @IdRes int viewId, @Nullable CharSequence text, boolean visible) {
        if (remoteViews == null) {
            return;
        }
        if (text != null && !TextUtils.isEmpty((CharSequence)text)) {
            DynamicViewUtils.setTextViewText(remoteViews, viewId, (CharSequence)HtmlCompat.fromHtml((String)((String)text), (int)63), visible);
        } else {
            remoteViews.setViewVisibility(viewId, 8);
        }
    }

    public static void setTextViewTextHtml(@Nullable RemoteViews remoteViews, @IdRes int viewId, @Nullable CharSequence text) {
        DynamicViewUtils.setTextViewTextHtml(remoteViews, viewId, text, true);
    }

    public static void setTextViewAllCaps(@Nullable RemoteViews remoteViews, @IdRes int viewId, boolean allCaps) {
        if (remoteViews == null) {
            return;
        }
        remoteViews.setBoolean(viewId, "setAllCaps", allCaps);
    }

    public static void setTextViewAllCaps(@Nullable TextView textView, boolean allCaps) {
        if (textView == null) {
            return;
        }
        textView.setAllCaps(allCaps);
    }

    public static void setAlpha(@Nullable View view, @FloatRange(from=0.0, to=1.0) float alpha) {
        if (view == null) {
            return;
        }
        view.setAlpha(alpha);
    }

    public static void setAlpha(@Nullable RemoteViews remoteViews, @IdRes int viewId, @IntRange(from=0L, to=255L) int alpha) {
        if (remoteViews == null) {
            return;
        }
        remoteViews.setInt(viewId, "setAlpha", alpha);
    }

    public static void setEnabled(@Nullable RemoteViews remoteViews, @IdRes int viewId, boolean enabled) {
        if (remoteViews == null) {
            return;
        }
        remoteViews.setBoolean(viewId, "setEnabled", enabled);
    }

    public static void setBackgroundColor(@Nullable RemoteViews remoteViews, @IdRes int viewId, @ColorInt int color) {
        if (remoteViews == null) {
            return;
        }
        remoteViews.setInt(viewId, "setBackgroundColor", color);
    }

    public static void setColorFilter(@Nullable RemoteViews remoteViews, @IdRes int viewId, @ColorInt int color) {
        if (remoteViews == null) {
            return;
        }
        remoteViews.setInt(viewId, "setColorFilter", color);
    }

    public static void setTextViewLinkColor(@Nullable RemoteViews remoteViews, @IdRes int viewId, @ColorInt int color) {
        if (remoteViews == null) {
            return;
        }
        remoteViews.setInt(viewId, "setLinkTextColor", color);
    }

    public static void setTextViewColors(@Nullable RemoteViews remoteViews, @IdRes int viewId, @ColorInt int color, @ColorInt int linkColor) {
        if (remoteViews == null) {
            return;
        }
        remoteViews.setTextColor(viewId, color);
        DynamicViewUtils.setTextViewLinkColor(remoteViews, viewId, linkColor);
    }
}

