/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.os.AsyncTask;
import androidx.annotation.Nullable;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicConcurrent;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicStatus;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicTask;

public class DynamicTaskUtils {
    public static void executeTask(@Nullable AsyncTask<Object, ?, ?> task) {
        if (task == null) {
            return;
        }
        try {
            if (task.getStatus() == AsyncTask.Status.PENDING) {
                task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cancelTask(@Nullable AsyncTask<?, ?, ?> task) {
        if (task == null) {
            return;
        }
        try {
            task.cancel(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void executeTask(@Nullable DynamicTask<?, ?, ?> task) {
        if (task == null) {
            return;
        }
        try {
            if (task.getStatus() == DynamicStatus.PENDING) {
                task.executeOnExecutor(DynamicConcurrent.getInstance().getThreadPoolExecutor());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cancelTask(@Nullable DynamicTask<?, ?, ?> task, boolean mayInterruptIfRunning) {
        if (task == null) {
            return;
        }
        try {
            task.cancel(mayInterruptIfRunning);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

