/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import androidx.annotation.AnyRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class DynamicPackageUtils {
    @AnyRes
    public static final int ID_NULL = 0;

    public static boolean isPackageExists(@Nullable Context context, @Nullable String packageName) {
        if (context == null || packageName == null) {
            return false;
        }
        try {
            context.getPackageManager().getPackageInfo(packageName, 128);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @NonNull
    public static ComponentName getComponentName(@NonNull Context context) {
        return new ComponentName(context.getPackageName(), context.getClass().getName());
    }

    @Nullable
    public static CharSequence getAppLabel(@Nullable Context context, @Nullable String packageName) {
        if (context == null || packageName == null) {
            return null;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            return packageManager.getPackageInfo((String)packageName, (int)128).applicationInfo.loadLabel(packageManager);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static CharSequence getAppLabel(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        return DynamicPackageUtils.getAppLabel(context, context.getPackageName());
    }

    @Nullable
    public static String getVersionCode(@Nullable Context context, @Nullable String packageName) {
        if (context == null || packageName == null) {
            return null;
        }
        try {
            return Integer.toString(context.getPackageManager().getPackageInfo((String)packageName, (int)128).versionCode);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String getVersionCode(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        return DynamicPackageUtils.getVersionCode(context, context.getPackageName());
    }

    @Nullable
    public static String getVersionName(@Nullable Context context, @Nullable String packageName) {
        if (context == null || packageName == null) {
            return null;
        }
        try {
            return context.getPackageManager().getPackageInfo((String)packageName, (int)128).versionName;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String getVersionName(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        return DynamicPackageUtils.getVersionName(context, context.getPackageName());
    }

    @Nullable
    public static Drawable getAppIcon(@Nullable Context context, @Nullable String packageName) {
        if (context == null || packageName == null) {
            return null;
        }
        try {
            return context.getPackageManager().getApplicationIcon(packageName);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Drawable getAppIcon(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        return DynamicPackageUtils.getAppIcon(context, context.getPackageName());
    }

    @Nullable
    public static Drawable getActivityIcon(@Nullable Context context, @Nullable ComponentName componentName) {
        if (context == null || componentName == null) {
            return null;
        }
        try {
            return context.getPackageManager().getActivityIcon(componentName);
        }
        catch (Exception e) {
            return context.getPackageManager().getDefaultActivityIcon();
        }
    }

    @DrawableRes
    public static int getActivityIconRes(@Nullable Context context, @Nullable ComponentName componentName) {
        if (context == null || componentName == null) {
            return 0;
        }
        try {
            return context.getPackageManager().getActivityInfo(componentName, 128).getIconResource();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isSystemApp(@Nullable ApplicationInfo applicationInfo) {
        if (applicationInfo == null) {
            return false;
        }
        int mask = 129;
        return (applicationInfo.flags & mask) != 0;
    }
}

