/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ImageDecoder;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.MediaStore;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.pranavpandey.android.dynamic.util.DynamicSdkUtils;
import com.pranavpandey.android.dynamic.util.DynamicUnitUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class DynamicBitmapUtils {
    @TargetApi(value=28)
    @Nullable
    public static Bitmap getBitmap(@Nullable Context context, @Nullable Uri uri) {
        if (context != null && uri != null) {
            try {
                if (DynamicSdkUtils.is28()) {
                    return ImageDecoder.decodeBitmap((ImageDecoder.Source)ImageDecoder.createSource((ContentResolver)context.getContentResolver(), (Uri)uri));
                }
                return MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Bitmap getBitmap(@Nullable Drawable drawable, int width, int height, boolean compress, int quality) {
        if (drawable != null) {
            try {
                if (width < 0 || height < 0) {
                    width = 1;
                    height = 1;
                }
                Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable.draw(canvas);
                if (compress) {
                    ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)byteArray);
                    return BitmapFactory.decodeByteArray((byte[])byteArray.toByteArray(), (int)0, (int)byteArray.size());
                }
                return bitmap;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Bitmap getBitmap(@Nullable Drawable drawable, boolean compress, int quality) {
        if (drawable != null) {
            return DynamicBitmapUtils.getBitmap(drawable, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), compress, quality);
        }
        return null;
    }

    @Nullable
    public static Bitmap getBitmap(@Nullable Drawable drawable) {
        if (drawable != null) {
            return DynamicBitmapUtils.getBitmap(drawable, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), false, 0);
        }
        return null;
    }

    @Nullable
    public static Bitmap resizeBitmap(@Nullable Bitmap bitmap, int newWidth, int newHeight) {
        if (bitmap == null) {
            return null;
        }
        Bitmap resizedBitmap = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        float scaleX = (float)newWidth / (float)bitmap.getWidth();
        float scaleY = (float)newHeight / (float)bitmap.getHeight();
        float pivotX = 0.0f;
        float pivotY = 0.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(scaleX, scaleY, pivotX, pivotY);
        Paint paint = new Paint(1);
        paint.setFilterBitmap(true);
        Canvas canvas = new Canvas(resizedBitmap);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return resizedBitmap;
    }

    @Nullable
    public static Bitmap cropBitmap(@Nullable Bitmap bitmap, int newWidth, int newHeight) {
        if (bitmap == null) {
            return null;
        }
        Bitmap croppedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)newWidth, (int)newHeight);
        Paint paint = new Paint(1);
        paint.setFilterBitmap(true);
        Canvas canvas = new Canvas(croppedBitmap);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return croppedBitmap;
    }

    @Nullable
    public static Bitmap applyColorFilter(@Nullable Bitmap bitmap, @NonNull ColorFilter colorFilter) {
        if (bitmap == null) {
            return null;
        }
        Paint paint = new Paint(1);
        paint.setColorFilter(colorFilter);
        paint.setFilterBitmap(true);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return bitmap;
    }

    @Nullable
    public static Bitmap applyColorFilter(@Nullable Bitmap bitmap, @ColorInt int color) {
        return DynamicBitmapUtils.applyColorFilter(bitmap, (ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_ATOP));
    }

    @ColorInt
    public static int getDominantColor(@NonNull Bitmap bitmap) {
        Bitmap newBitmap = DynamicBitmapUtils.resizeBitmap(bitmap, 1, 1);
        int color = newBitmap.getPixel(0, 0);
        newBitmap.recycle();
        return color;
    }

    @Nullable
    public static Bitmap createBitmap(@Nullable View view, int width, int height) {
        if (view == null) {
            return null;
        }
        int oldWidth = view.getWidth();
        int oldHeight = view.getHeight();
        if (width > 0 && height > 0) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)DynamicUnitUtils.convertDpToPixels(width), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)DynamicUnitUtils.convertDpToPixels(height), (int)0x40000000));
        }
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        Bitmap bitmap = Bitmap.createBitmap((int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Drawable background = view.getBackground();
        if (background != null) {
            background.draw(canvas);
        }
        view.draw(canvas);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)oldWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)oldHeight, (int)0x40000000));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        return bitmap;
    }

    @Nullable
    public static Bitmap createBitmap(@Nullable View view) {
        return DynamicBitmapUtils.createBitmap(view, 0, 0);
    }
}

