/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.toasts.internal;

import android.content.Context;
import android.content.ContextWrapper;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Toast;
import androidx.annotation.NonNull;

public final class ToastContext
extends ContextWrapper {
    @NonNull
    private Toast toast;

    public ToastContext(@NonNull Context base, @NonNull Toast toast) {
        super(base);
        this.toast = toast;
    }

    public Context getApplicationContext() {
        return new ApplicationContextWrapper(this.getBaseContext().getApplicationContext());
    }

    static final class WindowManagerWrapper
    implements WindowManager {
        @NonNull
        private final WindowManager base;

        private WindowManagerWrapper(@NonNull WindowManager base) {
            this.base = base;
        }

        public Display getDefaultDisplay() {
            return this.base.getDefaultDisplay();
        }

        public void removeViewImmediate(View view) {
            this.base.removeViewImmediate(view);
        }

        public void addView(View view, ViewGroup.LayoutParams params) {
            try {
                this.base.addView(view, params);
            }
            catch (WindowManager.BadTokenException e) {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
            this.base.updateViewLayout(view, params);
        }

        public void removeView(View view) {
            this.base.removeView(view);
        }
    }

    static final class ApplicationContextWrapper
    extends ContextWrapper {
        private ApplicationContextWrapper(@NonNull Context base) {
            super(base);
        }

        public Object getSystemService(@NonNull String name) {
            Object service = null;
            if ("window".equals(name)) {
                service = this.getBaseContext().getSystemService(name);
            }
            if (service != null) {
                return new WindowManagerWrapper((WindowManager)service);
            }
            return super.getSystemService(name);
        }
    }
}

