/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.toasts;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.pranavpandey.android.dynamic.toasts.R;
import com.pranavpandey.android.dynamic.toasts.internal.ToastCompat;
import com.pranavpandey.android.dynamic.util.DynamicColorUtils;
import com.pranavpandey.android.dynamic.util.DynamicDrawableUtils;

public class DynamicToast {
    @ColorInt
    private static final int ADT_DEFAULT_BG_COLOR = Color.parseColor((String)"#454545");
    @ColorInt
    private static final int ADT_DEFAULT_TINT_COLOR = Color.parseColor((String)"#FFFFFF");
    @ColorInt
    private static final int ADT_DEFAULT_ERROR_BG_COLOR = Color.parseColor((String)"#F44336");
    @ColorInt
    private static final int ADT_DEFAULT_SUCCESS_BG_COLOR = Color.parseColor((String)"#4CAF50");
    @ColorInt
    private static final int ADT_DEFAULT_WARNING_BG_COLOR = Color.parseColor((String)"#FFEB3B");
    private static final boolean ADT_DEFAULT_DISABLE_ICON = false;
    private static final boolean ADT_DEFAULT_TINT_ICON = true;
    @ColorInt
    private static final int ADT_DEFAULT_ICON_SIZE = -1;
    @ColorInt
    private static final int ADT_DEFAULT_TEXT_SIZE = -1;
    @Nullable
    @ColorInt
    private static Integer defaultBackgroundColor = ADT_DEFAULT_BG_COLOR;
    @Nullable
    @ColorInt
    private static Integer defaultTintColor = ADT_DEFAULT_TINT_COLOR;
    @Nullable
    @ColorInt
    private static Integer errorBackgroundColor = ADT_DEFAULT_ERROR_BG_COLOR;
    @Nullable
    @ColorInt
    private static Integer successBackgroundColor = ADT_DEFAULT_SUCCESS_BG_COLOR;
    @Nullable
    @ColorInt
    private static Integer warningBackgroundColor = ADT_DEFAULT_WARNING_BG_COLOR;
    private static Drawable errorIcon = null;
    private static Drawable successIcon = null;
    private static Drawable warningIcon = null;
    private static boolean disableIcon = false;
    private static boolean tintIcon = true;
    private static int iconSize = -1;
    private static int textSize = -1;
    private static Typeface textTypeface = null;
    private static Drawable toastBackground = null;

    @Nullable
    @ColorInt
    private static Integer generateTintColor(@Nullable @ColorInt Integer color, @Nullable @ColorInt Integer defaultColor) {
        if (color != null) {
            return DynamicColorUtils.getTintColor((int)color);
        }
        return defaultColor;
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text) {
        return DynamicToast.make(context, text, null, defaultTintColor, defaultBackgroundColor, 0);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, int duration) {
        return DynamicToast.make(context, text, null, defaultTintColor, defaultBackgroundColor, duration);
    }

    @NonNull
    public static Toast makeError(@NonNull Context context, @Nullable CharSequence text) {
        return DynamicToast.make(context, text, errorIcon != null ? errorIcon : ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_error), DynamicToast.generateTintColor(errorBackgroundColor, defaultTintColor), errorBackgroundColor);
    }

    @NonNull
    public static Toast makeError(@NonNull Context context, @Nullable CharSequence text, int duration) {
        return DynamicToast.make(context, text, ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_error), DynamicToast.generateTintColor(errorBackgroundColor, defaultTintColor), errorBackgroundColor, duration);
    }

    @NonNull
    public static Toast makeSuccess(@NonNull Context context, @Nullable CharSequence text) {
        return DynamicToast.make(context, text, successIcon != null ? successIcon : ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_success), DynamicToast.generateTintColor(successBackgroundColor, defaultTintColor), successBackgroundColor);
    }

    @NonNull
    public static Toast makeSuccess(@NonNull Context context, @Nullable CharSequence text, int duration) {
        return DynamicToast.make(context, text, ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_success), DynamicToast.generateTintColor(successBackgroundColor, defaultTintColor), successBackgroundColor, duration);
    }

    @NonNull
    public static Toast makeWarning(@NonNull Context context, @Nullable CharSequence text) {
        return DynamicToast.make(context, text, warningIcon != null ? warningIcon : ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_warning), DynamicToast.generateTintColor(warningBackgroundColor, defaultTintColor), warningBackgroundColor);
    }

    @NonNull
    public static Toast makeWarning(@NonNull Context context, @Nullable CharSequence text, int duration) {
        return DynamicToast.make(context, text, ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_warning), DynamicToast.generateTintColor(warningBackgroundColor, defaultTintColor), warningBackgroundColor, duration);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable Drawable icon) {
        return DynamicToast.make(context, text, icon, defaultTintColor, defaultBackgroundColor, 0);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable Drawable icon, int duration) {
        return DynamicToast.make(context, text, icon, defaultTintColor, defaultBackgroundColor, duration);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable @ColorInt Integer tintColor, @Nullable @ColorInt Integer backgroundColor) {
        return DynamicToast.make(context, text, null, tintColor, backgroundColor, 0);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable @ColorInt Integer tintColor, @Nullable @ColorInt Integer backgroundColor, int duration) {
        return DynamicToast.make(context, text, null, tintColor, backgroundColor, duration);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable Drawable icon, @Nullable @ColorInt Integer tintColor, @Nullable @ColorInt Integer backgroundColor) {
        return DynamicToast.make(context, text, icon, tintColor, backgroundColor, 0);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable Drawable icon, @Nullable @ColorInt Integer tintColor, @Nullable @ColorInt Integer backgroundColor, int duration) {
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            context = context.getApplicationContext();
        }
        Integer toastTintColor = tintColor;
        if (tintColor != null && backgroundColor != null) {
            toastTintColor = DynamicColorUtils.getContrastColor((int)toastTintColor, (int)backgroundColor);
        }
        ToastCompat toast = new ToastCompat(context, new Toast(context));
        View toastLayout = LayoutInflater.from((Context)context).inflate(R.layout.adt_layout_toast, (ViewGroup)new LinearLayout(context), false);
        ImageView toastIcon = (ImageView)toastLayout.findViewById(R.id.adt_toast_icon);
        TextView toastText = (TextView)toastLayout.findViewById(R.id.adt_toast_text);
        if (!disableIcon && icon != null) {
            if (iconSize != -1) {
                toastIcon.getLayoutParams().width = iconSize;
                toastIcon.getLayoutParams().height = iconSize;
                toastIcon.requestLayout();
            }
            if (tintIcon && toastTintColor != null) {
                toastIcon.setColorFilter(toastTintColor.intValue());
            } else {
                toastIcon.clearColorFilter();
            }
            toastIcon.setImageDrawable(icon);
        } else {
            toastIcon.setVisibility(8);
        }
        if (textTypeface != null) {
            toastText.setTypeface(textTypeface);
        }
        if (textSize != -1) {
            toastText.setTextSize(2, (float)textSize);
        }
        if (toastTintColor != null) {
            toastText.setTextColor(toastTintColor.intValue());
        }
        toastText.setText(text);
        if (toastBackground != null) {
            DynamicDrawableUtils.setBackground((View)toastLayout, (Drawable)(backgroundColor != null ? DynamicDrawableUtils.colorizeDrawable((Drawable)toastBackground, (int)backgroundColor, (PorterDuff.Mode)PorterDuff.Mode.MULTIPLY) : toastBackground));
        } else {
            DynamicDrawableUtils.setBackground((View)toastLayout, (Drawable)(backgroundColor != null ? DynamicDrawableUtils.colorizeDrawable((Drawable)ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_toast_background), (int)backgroundColor, (PorterDuff.Mode)PorterDuff.Mode.MULTIPLY) : ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_toast_background)));
        }
        toast.setDuration(duration);
        toast.setView(toastLayout);
        return toast;
    }

    static /* synthetic */ Integer access$000() {
        return defaultBackgroundColor;
    }

    static /* synthetic */ Integer access$100() {
        return defaultTintColor;
    }

    static /* synthetic */ Integer access$200() {
        return errorBackgroundColor;
    }

    static /* synthetic */ Integer access$300() {
        return successBackgroundColor;
    }

    static /* synthetic */ Integer access$400() {
        return warningBackgroundColor;
    }

    static /* synthetic */ Drawable access$500() {
        return errorIcon;
    }

    static /* synthetic */ Drawable access$600() {
        return successIcon;
    }

    static /* synthetic */ Drawable access$700() {
        return warningIcon;
    }

    static /* synthetic */ boolean access$800() {
        return disableIcon;
    }

    static /* synthetic */ boolean access$900() {
        return tintIcon;
    }

    static /* synthetic */ int access$1000() {
        return iconSize;
    }

    static /* synthetic */ int access$1100() {
        return textSize;
    }

    public static class Config {
        private static Config sInstance;
        @ColorInt
        private Integer defaultBackgroundColor = DynamicToast.access$000();
        @ColorInt
        private Integer defaultTintColor = DynamicToast.access$100();
        @ColorInt
        private Integer errorBackgroundColor = DynamicToast.access$200();
        @ColorInt
        private Integer successBackgroundColor = DynamicToast.access$300();
        @ColorInt
        private Integer warningBackgroundColor = DynamicToast.access$400();
        private Drawable errorIcon = DynamicToast.access$500();
        private Drawable successIcon = DynamicToast.access$600();
        private Drawable warningIcon = DynamicToast.access$700();
        private boolean disableIcon = DynamicToast.access$800();
        private boolean tintIcon = DynamicToast.access$900();
        private int iconSize = DynamicToast.access$1000();
        @ColorInt
        private int textSize = DynamicToast.access$1100();
        private Typeface textTypeface = null;
        private Drawable toastBackground = null;

        private Config() {
        }

        @NonNull
        public static Config getInstance() {
            if (sInstance == null) {
                sInstance = new Config();
            }
            return sInstance;
        }

        @NonNull
        public Config setDefaultBackgroundColor(@Nullable @ColorInt Integer defaultBackgroundColor) {
            this.defaultBackgroundColor = defaultBackgroundColor;
            return this;
        }

        @NonNull
        public Config setDefaultTintColor(@Nullable @ColorInt Integer defaultTintColor) {
            this.defaultTintColor = defaultTintColor;
            return this;
        }

        @NonNull
        public Config setErrorBackgroundColor(@Nullable @ColorInt Integer errorBackgroundColor) {
            this.errorBackgroundColor = errorBackgroundColor;
            return this;
        }

        @NonNull
        public Config setSuccessBackgroundColor(@Nullable @ColorInt Integer successBackgroundColor) {
            this.successBackgroundColor = successBackgroundColor;
            return this;
        }

        @NonNull
        public Config setWarningBackgroundColor(@Nullable @ColorInt Integer warningBackgroundColor) {
            this.warningBackgroundColor = warningBackgroundColor;
            return this;
        }

        @NonNull
        public Config setErrorIcon(@Nullable Drawable errorIcon) {
            this.errorIcon = errorIcon;
            return this;
        }

        @NonNull
        public Config setSuccessIcon(@Nullable Drawable successIcon) {
            this.successIcon = successIcon;
            return this;
        }

        @NonNull
        public Config setWarningIcon(@Nullable Drawable warningIcon) {
            this.warningIcon = warningIcon;
            return this;
        }

        @NonNull
        public Config setDisableIcon(boolean disableIcon) {
            this.disableIcon = disableIcon;
            return this;
        }

        @NonNull
        public Config setTintIcon(boolean tintIcon) {
            this.tintIcon = tintIcon;
            return this;
        }

        @NonNull
        public Config setIconSize(int iconSize) {
            this.iconSize = iconSize;
            return this;
        }

        @NonNull
        public Config setTextSize(int textSize) {
            this.textSize = textSize;
            return this;
        }

        @NonNull
        public Config setTextTypeface(@Nullable Typeface textTypeface) {
            this.textTypeface = textTypeface;
            return this;
        }

        @NonNull
        public Config setToastBackground(@Nullable Drawable toastBackground) {
            this.toastBackground = toastBackground;
            return this;
        }

        public void apply() {
            defaultBackgroundColor = this.defaultBackgroundColor;
            defaultTintColor = this.defaultTintColor;
            errorBackgroundColor = this.errorBackgroundColor;
            successBackgroundColor = this.successBackgroundColor;
            warningBackgroundColor = this.warningBackgroundColor;
            errorIcon = this.errorIcon;
            successIcon = this.successIcon;
            warningIcon = this.warningIcon;
            disableIcon = this.disableIcon;
            tintIcon = this.tintIcon;
            iconSize = this.iconSize;
            textSize = this.textSize;
            textTypeface = this.textTypeface;
            toastBackground = this.toastBackground;
            sInstance = null;
        }

        public void reset() {
            defaultBackgroundColor = ADT_DEFAULT_BG_COLOR;
            defaultTintColor = ADT_DEFAULT_TINT_COLOR;
            errorBackgroundColor = ADT_DEFAULT_ERROR_BG_COLOR;
            successBackgroundColor = ADT_DEFAULT_SUCCESS_BG_COLOR;
            warningBackgroundColor = ADT_DEFAULT_WARNING_BG_COLOR;
            errorIcon = null;
            successIcon = null;
            warningIcon = null;
            disableIcon = false;
            tintIcon = true;
            iconSize = -1;
            textSize = -1;
            textTypeface = null;
            toastBackground = null;
            sInstance = null;
        }
    }
}

