/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.epub.BookProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookProcessorPipeline
implements BookProcessor {
    private Logger log = LoggerFactory.getLogger(BookProcessorPipeline.class);
    private List<BookProcessor> bookProcessors;

    public BookProcessorPipeline() {
        this(null);
    }

    public BookProcessorPipeline(List<BookProcessor> bookProcessingPipeline) {
        this.bookProcessors = bookProcessingPipeline;
    }

    @Override
    public Book processBook(Book book) {
        if (this.bookProcessors == null) {
            return book;
        }
        for (BookProcessor bookProcessor : this.bookProcessors) {
            try {
                book = bookProcessor.processBook(book);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return book;
    }

    public void addBookProcessor(BookProcessor bookProcessor) {
        if (this.bookProcessors == null) {
            this.bookProcessors = new ArrayList<BookProcessor>();
        }
        this.bookProcessors.add(bookProcessor);
    }

    public void addBookProcessors(Collection<BookProcessor> bookProcessors) {
        if (this.bookProcessors == null) {
            this.bookProcessors = new ArrayList<BookProcessor>();
        }
        this.bookProcessors.addAll(bookProcessors);
    }

    public List<BookProcessor> getBookProcessors() {
        return this.bookProcessors;
    }

    public void setBookProcessingPipeline(List<BookProcessor> bookProcessingPipeline) {
        this.bookProcessors = bookProcessingPipeline;
    }
}

