/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.jazzlib.CRC32;
import net.sf.jazzlib.Deflater;
import net.sf.jazzlib.DeflaterOutputStream;
import net.sf.jazzlib.ZipConstants;
import net.sf.jazzlib.ZipEntry;
import net.sf.jazzlib.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private Vector entries = new Vector();
    private final CRC32 crc = new CRC32();
    private ZipEntry curEntry = null;
    private int curMethod;
    private int size;
    private int offset = 0;
    private byte[] zipComment = new byte[0];
    private int defaultMethod = 8;
    private static final int ZIP_STORED_VERSION = 10;
    private static final int ZIP_DEFLATED_VERSION = 20;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipOutputStream(OutputStream out) {
        super(out, new Deflater(-1, true));
    }

    public void setComment(String comment) {
        byte[] commentBytes = comment.getBytes();
        if (commentBytes.length > 65535) {
            throw new IllegalArgumentException("Comment too long.");
        }
        this.zipComment = commentBytes;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("Method not supported.");
        }
        this.defaultMethod = method;
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    private final void writeLeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    private final void writeLeInt(int value) throws IOException {
        this.writeLeShort(value);
        this.writeLeShort(value >> 16);
    }

    public void putNextEntry(ZipEntry entry) throws IOException {
        if (this.entries == null) {
            throw new ZipException("ZipOutputStream was finished");
        }
        int method = entry.getMethod();
        int flags = 0;
        if (method == -1) {
            method = this.defaultMethod;
        }
        if (method == 0) {
            if (entry.getCompressedSize() >= 0L) {
                if (entry.getSize() < 0L) {
                    entry.setSize(entry.getCompressedSize());
                } else if (entry.getSize() != entry.getCompressedSize()) {
                    throw new ZipException("Method STORED, but compressed size != size");
                }
            } else {
                entry.setCompressedSize(entry.getSize());
            }
            if (entry.getSize() < 0L) {
                throw new ZipException("Method STORED, but size not set");
            }
            if (entry.getCrc() < 0L) {
                throw new ZipException("Method STORED, but crc not set");
            }
        } else if (method == 8 && (entry.getCompressedSize() < 0L || entry.getSize() < 0L || entry.getCrc() < 0L)) {
            flags |= 8;
        }
        if (this.curEntry != null) {
            this.closeEntry();
        }
        if (entry.getTime() < 0L) {
            entry.setTime(System.currentTimeMillis());
        }
        entry.flags = flags;
        entry.offset = this.offset;
        entry.setMethod(method);
        this.curMethod = method;
        this.writeLeInt(67324752);
        this.writeLeShort(method == 0 ? 10 : 20);
        this.writeLeShort(flags);
        this.writeLeShort(method);
        this.writeLeInt(entry.getDOSTime());
        if ((flags & 8) == 0) {
            this.writeLeInt((int)entry.getCrc());
            this.writeLeInt((int)entry.getCompressedSize());
            this.writeLeInt((int)entry.getSize());
        } else {
            this.writeLeInt(0);
            this.writeLeInt(0);
            this.writeLeInt(0);
        }
        byte[] name = entry.getName().getBytes();
        if (name.length > 65535) {
            throw new ZipException("Name too long.");
        }
        byte[] extra = entry.getExtra();
        if (extra == null) {
            extra = new byte[]{};
        }
        this.writeLeShort(name.length);
        this.writeLeShort(extra.length);
        this.out.write(name);
        this.out.write(extra);
        this.offset += 30 + name.length + extra.length;
        this.curEntry = entry;
        this.crc.reset();
        if (method == 8) {
            this.def.reset();
        }
        this.size = 0;
    }

    public void closeEntry() throws IOException {
        int csize;
        if (this.curEntry == null) {
            throw new ZipException("No open entry");
        }
        if (this.curMethod == 8) {
            super.finish();
        }
        int n = csize = this.curMethod == 8 ? this.def.getTotalOut() : this.size;
        if (this.curEntry.getSize() < 0L) {
            this.curEntry.setSize(this.size);
        } else if (this.curEntry.getSize() != (long)this.size) {
            throw new ZipException("size was " + this.size + ", but I expected " + this.curEntry.getSize());
        }
        if (this.curEntry.getCompressedSize() < 0L) {
            this.curEntry.setCompressedSize(csize);
        } else if (this.curEntry.getCompressedSize() != (long)csize) {
            throw new ZipException("compressed size was " + csize + ", but I expected " + this.curEntry.getSize());
        }
        if (this.curEntry.getCrc() < 0L) {
            this.curEntry.setCrc(this.crc.getValue());
        } else if (this.curEntry.getCrc() != this.crc.getValue()) {
            throw new ZipException("crc was " + Long.toHexString(this.crc.getValue()) + ", but I expected " + Long.toHexString(this.curEntry.getCrc()));
        }
        this.offset += csize;
        if (this.curMethod == 8 && (this.curEntry.flags & 8) != 0) {
            this.writeLeInt(134695760);
            this.writeLeInt((int)this.curEntry.getCrc());
            this.writeLeInt((int)this.curEntry.getCompressedSize());
            this.writeLeInt((int)this.curEntry.getSize());
            this.offset += 16;
        }
        this.entries.addElement(this.curEntry);
        this.curEntry = null;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.curEntry == null) {
            throw new ZipException("No open entry.");
        }
        switch (this.curMethod) {
            case 8: {
                super.write(b, off, len);
                break;
            }
            case 0: {
                this.out.write(b, off, len);
            }
        }
        this.crc.update(b, off, len);
        this.size += len;
    }

    @Override
    public void finish() throws IOException {
        if (this.entries == null) {
            return;
        }
        if (this.curEntry != null) {
            this.closeEntry();
        }
        int numEntries = 0;
        int sizeEntries = 0;
        Enumeration elements = this.entries.elements();
        while (elements.hasMoreElements()) {
            String strComment;
            byte[] comment;
            ZipEntry entry = (ZipEntry)elements.nextElement();
            int method = entry.getMethod();
            this.writeLeInt(33639248);
            this.writeLeShort(method == 0 ? 10 : 20);
            this.writeLeShort(method == 0 ? 10 : 20);
            this.writeLeShort(entry.flags);
            this.writeLeShort(method);
            this.writeLeInt(entry.getDOSTime());
            this.writeLeInt((int)entry.getCrc());
            this.writeLeInt((int)entry.getCompressedSize());
            this.writeLeInt((int)entry.getSize());
            byte[] name = entry.getName().getBytes();
            if (name.length > 65535) {
                throw new ZipException("Name too long.");
            }
            byte[] extra = entry.getExtra();
            if (extra == null) {
                extra = new byte[]{};
            }
            byte[] byArray = comment = (strComment = entry.getComment()) != null ? strComment.getBytes() : new byte[]{};
            if (comment.length > 65535) {
                throw new ZipException("Comment too long.");
            }
            this.writeLeShort(name.length);
            this.writeLeShort(extra.length);
            this.writeLeShort(comment.length);
            this.writeLeShort(0);
            this.writeLeShort(0);
            this.writeLeInt(0);
            this.writeLeInt(entry.offset);
            this.out.write(name);
            this.out.write(extra);
            this.out.write(comment);
            ++numEntries;
            sizeEntries += 46 + name.length + extra.length + comment.length;
        }
        this.writeLeInt(101010256);
        this.writeLeShort(0);
        this.writeLeShort(0);
        this.writeLeShort(numEntries);
        this.writeLeShort(numEntries);
        this.writeLeInt(sizeEntries);
        this.writeLeInt(this.offset);
        this.writeLeShort(this.zipComment.length);
        this.out.write(this.zipComment);
        this.out.flush();
        this.entries = null;
    }
}

