/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import net.sf.jazzlib.DataFormatException;
import net.sf.jazzlib.DeflaterHuffman;
import net.sf.jazzlib.StreamManipulator;

public class InflaterHuffmanTree {
    private static final int MAX_BITLEN = 15;
    private short[] tree;
    public static InflaterHuffmanTree defLitLenTree;
    public static InflaterHuffmanTree defDistTree;

    public InflaterHuffmanTree(byte[] codeLengths) throws DataFormatException {
        this.buildTree(codeLengths);
    }

    private void buildTree(byte[] codeLengths) throws DataFormatException {
        int end;
        byte bits;
        int[] blCount = new int[16];
        int[] nextCode = new int[16];
        for (byte codeLength : codeLengths) {
            bits = codeLength;
            if (bits <= 0) continue;
            byte by = bits;
            blCount[by] = blCount[by] + 1;
        }
        int code = 0;
        int treeSize = 512;
        for (int bits2 = 1; bits2 <= 15; ++bits2) {
            nextCode[bits2] = code;
            code += blCount[bits2] << 16 - bits2;
            if (bits2 < 10) continue;
            int start = nextCode[bits2] & 0x1FF80;
            end = code & 0x1FF80;
            treeSize += end - start >> 16 - bits2;
        }
        if (code != 65536) {
            throw new DataFormatException("Code lengths don't add up properly.");
        }
        this.tree = new short[treeSize];
        int treePtr = 512;
        for (int bits3 = 15; bits3 >= 10; --bits3) {
            int start;
            end = code & 0x1FF80;
            for (int i = start = (code -= blCount[bits3] << 16 - bits3) & 0x1FF80; i < end; i += 128) {
                this.tree[DeflaterHuffman.bitReverse((int)i)] = (short)(-treePtr << 4 | bits3);
                treePtr += 1 << bits3 - 9;
            }
        }
        for (int i = 0; i < codeLengths.length; ++i) {
            bits = codeLengths[i];
            if (bits == 0) continue;
            code = nextCode[bits];
            int revcode = DeflaterHuffman.bitReverse(code);
            if (bits <= 9) {
                do {
                    this.tree[revcode] = (short)(i << 4 | bits);
                } while ((revcode += 1 << bits) < 512);
            } else {
                int subTree = this.tree[revcode & 0x1FF];
                int treeLen = 1 << (subTree & 0xF);
                subTree = -(subTree >> 4);
                do {
                    this.tree[subTree | revcode >> 9] = (short)(i << 4 | bits);
                } while ((revcode += 1 << bits) < treeLen);
            }
            nextCode[bits] = code + (1 << 16 - bits);
        }
    }

    public int getSymbol(StreamManipulator input) throws DataFormatException {
        int lookahead = input.peekBits(9);
        if (lookahead >= 0) {
            short symbol = this.tree[lookahead];
            if (symbol >= 0) {
                input.dropBits(symbol & 0xF);
                return symbol >> 4;
            }
            int subtree = -(symbol >> 4);
            int bitlen = symbol & 0xF;
            lookahead = input.peekBits(bitlen);
            if (lookahead >= 0) {
                symbol = this.tree[subtree | lookahead >> 9];
                input.dropBits(symbol & 0xF);
                return symbol >> 4;
            }
            int bits = input.getAvailableBits();
            lookahead = input.peekBits(bits);
            symbol = this.tree[subtree | lookahead >> 9];
            if ((symbol & 0xF) <= bits) {
                input.dropBits(symbol & 0xF);
                return symbol >> 4;
            }
            return -1;
        }
        int bits = input.getAvailableBits();
        lookahead = input.peekBits(bits);
        short symbol = this.tree[lookahead];
        if (symbol >= 0 && (symbol & 0xF) <= bits) {
            input.dropBits(symbol & 0xF);
            return symbol >> 4;
        }
        return -1;
    }

    static {
        try {
            byte[] codeLengths = new byte[288];
            int i = 0;
            while (i < 144) {
                codeLengths[i++] = 8;
            }
            while (i < 256) {
                codeLengths[i++] = 9;
            }
            while (i < 280) {
                codeLengths[i++] = 7;
            }
            while (i < 288) {
                codeLengths[i++] = 8;
            }
            defLitLenTree = new InflaterHuffmanTree(codeLengths);
            codeLengths = new byte[32];
            i = 0;
            while (i < 32) {
                codeLengths[i++] = 5;
            }
            defDistTree = new InflaterHuffmanTree(codeLengths);
        }
        catch (DataFormatException ex) {
            throw new InternalError("InflaterHuffmanTree: static tree length illegal");
        }
    }
}

