/*
 * Decompiled with CFR 0.152.
 */
package org.near.borshj;

import androidx.annotation.NonNull;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.near.borshj.BorshOutput;

public class BorshWriter
implements BorshOutput<BorshWriter>,
Closeable,
Flushable {
    protected final OutputStream stream;

    public BorshWriter(@NonNull OutputStream stream) {
        this.stream = Objects.requireNonNull(stream);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    @NonNull
    public BorshWriter write(@NonNull byte[] array) {
        try {
            this.stream.write(array);
            return this;
        }
        catch (IOException error) {
            throw new RuntimeException(error);
        }
    }

    @Override
    @NonNull
    public BorshWriter write(byte b) {
        try {
            this.stream.write(b);
            return this;
        }
        catch (IOException error) {
            throw new RuntimeException(error);
        }
    }
}

