/*
 * Decompiled with CFR 0.152.
 */
package org.near.borshj;

import androidx.annotation.NonNull;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.near.borshj.BorshInput;

public class BorshReader
implements BorshInput,
Closeable {
    private final InputStream stream;

    public BorshReader(@NonNull InputStream stream) {
        this.stream = Objects.requireNonNull(stream);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public byte read() {
        try {
            int result = this.stream.read();
            if (result == -1) {
                throw new EOFException();
            }
            return (byte)result;
        }
        catch (IOException error) {
            throw new RuntimeException(error);
        }
    }

    @Override
    public void read(@NonNull byte[] result, int offset, int length) {
        if (offset < 0 || length < 0 || length > result.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int count;
            for (int n = 0; n < length; n += count) {
                count = this.stream.read(result, offset + n, length - n);
                if (count != -1) continue;
                throw new EOFException();
            }
        }
        catch (IOException error) {
            throw new RuntimeException(error);
        }
    }
}

