/*
 * Decompiled with CFR 0.152.
 */
package org.near.borshj;

import androidx.annotation.NonNull;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.near.borshj.Borsh;
import org.near.borshj.BorshBuffer;

public interface BorshOutput<Self> {
    @NonNull
    default public Self write(@NonNull Object object) {
        Objects.requireNonNull(object);
        if (object instanceof Byte) {
            return this.writeU8((Byte)object);
        }
        if (object instanceof Short) {
            return this.writeU16((Short)object);
        }
        if (object instanceof Integer) {
            return this.writeU32((Integer)object);
        }
        if (object instanceof Long) {
            return this.writeU64((Long)object);
        }
        if (object instanceof Float) {
            return this.writeF32(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.writeF64((Double)object);
        }
        if (object instanceof BigInteger) {
            return this.writeU128((BigInteger)object);
        }
        if (object instanceof String) {
            return this.writeString((String)object);
        }
        if (object instanceof List) {
            return this.writeArray((List)object);
        }
        if (object instanceof Boolean) {
            return this.writeBoolean((Boolean)object);
        }
        if (object instanceof Optional) {
            return this.writeOptional((Optional)object);
        }
        if (object instanceof Borsh) {
            return this.writePOJO(object);
        }
        throw new IllegalArgumentException();
    }

    @NonNull
    default public Self writePOJO(@NonNull Object object) {
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                this.write(field.get(object));
            }
        }
        catch (IllegalAccessException error) {
            throw new RuntimeException(error);
        }
        return (Self)this;
    }

    @NonNull
    default public Self writeU8(int value) {
        return this.writeU8((byte)value);
    }

    @NonNull
    default public Self writeU8(byte value) {
        return this.write(value);
    }

    @NonNull
    default public Self writeU16(int value) {
        return this.writeU16((short)value);
    }

    @NonNull
    default public Self writeU16(short value) {
        return this.writeBuffer(BorshBuffer.allocate(2).writeU16(value));
    }

    @NonNull
    default public Self writeU32(int value) {
        return this.writeBuffer(BorshBuffer.allocate(4).writeU32(value));
    }

    @NonNull
    default public Self writeU64(long value) {
        return this.writeBuffer(BorshBuffer.allocate(8).writeU64(value));
    }

    @NonNull
    default public Self writeU128(long value) {
        return this.writeU128(BigInteger.valueOf(value));
    }

    @NonNull
    default public Self writeU128(@NonNull BigInteger value) {
        int i;
        if (value.signum() == -1) {
            throw new ArithmeticException("integer underflow");
        }
        if (value.bitLength() > 128) {
            throw new ArithmeticException("integer overflow");
        }
        byte[] bytes = value.toByteArray();
        for (i = bytes.length - 1; i >= 0; --i) {
            this.write(bytes[i]);
        }
        for (i = 0; i < 16 - bytes.length; ++i) {
            this.write((byte)0);
        }
        return (Self)this;
    }

    @NonNull
    default public Self writeF32(float value) {
        return this.writeBuffer(BorshBuffer.allocate(4).writeF32(value));
    }

    @NonNull
    default public Self writeF64(double value) {
        return this.writeBuffer(BorshBuffer.allocate(8).writeF64(value));
    }

    @NonNull
    default public Self writeString(@NonNull String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        this.writeU32(bytes.length);
        return this.write(bytes);
    }

    @NonNull
    default public Self writeFixedArray(@NonNull byte[] array) {
        return this.write(array);
    }

    @NonNull
    default public <T> Self writeArray(@NonNull T[] array) {
        this.writeU32(array.length);
        for (T element : array) {
            this.write(element);
        }
        return (Self)this;
    }

    @NonNull
    default public <T> Self writeArray(@NonNull List<T> list) {
        this.writeU32(list.size());
        for (T element : list) {
            this.write(element);
        }
        return (Self)this;
    }

    @NonNull
    default public <T> Self writeBoolean(boolean value) {
        return this.writeU8(value ? 1 : 0);
    }

    @NonNull
    default public <T> Self writeOptional(@NonNull Optional<T> optional) {
        if (optional.isPresent()) {
            this.writeU8(1);
            return this.write(optional.get());
        }
        return this.writeU8(0);
    }

    @NonNull
    default public Self writeBuffer(@NonNull BorshBuffer buffer) {
        return this.write(buffer.toByteArray());
    }

    @NonNull
    public Self write(@NonNull byte[] var1);

    @NonNull
    public Self write(byte var1);
}

