/*
 * Decompiled with CFR 0.152.
 */
package org.near.borshj;

import androidx.annotation.NonNull;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.near.borshj.Borsh;
import org.near.borshj.BorshBuffer;

public interface BorshInput {
    default public <T> T read(@NonNull Class klass) {
        if (klass == Byte.class || klass == Byte.TYPE) {
            return (T)Byte.valueOf(this.readU8());
        }
        if (klass == Short.class || klass == Short.TYPE) {
            return (T)Short.valueOf(this.readU16());
        }
        if (klass == Integer.class || klass == Integer.TYPE) {
            return (T)Integer.valueOf(this.readU32());
        }
        if (klass == Long.class || klass == Long.TYPE) {
            return (T)Long.valueOf(this.readU64());
        }
        if (klass == BigInteger.class) {
            return (T)this.readU128();
        }
        if (klass == Float.class || klass == Float.TYPE) {
            return (T)Float.valueOf(this.readF32());
        }
        if (klass == Double.class || klass == Double.TYPE) {
            return (T)Double.valueOf(this.readF64());
        }
        if (klass == String.class) {
            return (T)this.readString();
        }
        if (klass == Boolean.class) {
            return (T)Boolean.valueOf(this.readBoolean());
        }
        if (klass == Optional.class) {
            return (T)this.readOptional();
        }
        if (Borsh.isSerializable(klass)) {
            return this.readPOJO(klass);
        }
        throw new IllegalArgumentException();
    }

    default public <T> T readPOJO(@NonNull Class klass) {
        try {
            Object object = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : klass.getDeclaredFields()) {
                field.setAccessible(true);
                Class<?> fieldClass = field.getType();
                if (fieldClass == Optional.class) {
                    Type fieldType = field.getGenericType();
                    if (!(fieldType instanceof ParameterizedType)) {
                        throw new AssertionError((Object)"unsupported Optional type");
                    }
                    Type[] optionalArgs = ((ParameterizedType)fieldType).getActualTypeArguments();
                    if (!1.$assertionsDisabled && optionalArgs.length != 1) {
                        throw new AssertionError();
                    }
                    Class optionalClass = (Class)optionalArgs[0];
                    field.set(object, this.readOptional(optionalClass));
                    continue;
                }
                field.set(object, this.read(field.getType()));
            }
            return object;
        }
        catch (NoSuchMethodException error) {
            throw new RuntimeException(error);
        }
        catch (InstantiationException error) {
            throw new RuntimeException(error);
        }
        catch (IllegalAccessException error) {
            throw new RuntimeException(error);
        }
        catch (InvocationTargetException error) {
            throw new RuntimeException(error);
        }
    }

    default public byte readU8() {
        return this.read();
    }

    default public short readU16() {
        return BorshBuffer.wrap(this.read(2)).readU16();
    }

    default public int readU32() {
        return BorshBuffer.wrap(this.read(4)).readU32();
    }

    default public long readU64() {
        return BorshBuffer.wrap(this.read(8)).readU64();
    }

    @NonNull
    default public BigInteger readU128() {
        byte[] bytes = new byte[16];
        this.read(bytes);
        for (int i = 0; i < 8; ++i) {
            byte b;
            byte a = bytes[i];
            bytes[i] = b = bytes[15 - i];
            bytes[15 - i] = a;
        }
        return new BigInteger(bytes);
    }

    default public float readF32() {
        return BorshBuffer.wrap(this.read(4)).readF32();
    }

    default public double readF64() {
        return BorshBuffer.wrap(this.read(8)).readF64();
    }

    @NonNull
    default public String readString() {
        int length = this.readU32();
        byte[] bytes = new byte[length];
        this.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @NonNull
    default public byte[] readFixedArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = new byte[length];
        this.read(bytes);
        return bytes;
    }

    @NonNull
    default public <T> T[] readArray(@NonNull Class klass) {
        int length = this.readU32();
        Object[] elements = (Object[])Array.newInstance(klass, length);
        for (int i = 0; i < length; ++i) {
            elements[i] = this.read(klass);
        }
        return elements;
    }

    default public boolean readBoolean() {
        return this.readU8() != 0;
    }

    @NonNull
    default public <T> Optional<T> readOptional() {
        boolean isPresent;
        boolean bl = isPresent = this.readU8() != 0;
        if (!isPresent) {
            return Optional.empty();
        }
        throw new AssertionError((Object)"Optional type has been erased and cannot be reconstructed");
    }

    @NonNull
    default public <T> Optional<T> readOptional(@NonNull Class klass) {
        boolean isPresent = this.readU8() != 0;
        return isPresent ? Optional.of(this.read(klass)) : Optional.empty();
    }

    public byte read();

    default public byte[] read(int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] result = new byte[length];
        this.read(result);
        return result;
    }

    default public void read(@NonNull byte[] result) {
        this.read(result, 0, result.length);
    }

    public void read(@NonNull byte[] var1, int var2, int var3);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

