/*
 * Decompiled with CFR 0.152.
 */
package org.near.borshj;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import org.near.borshj.BorshInput;
import org.near.borshj.BorshOutput;

public class BorshBuffer
implements BorshInput,
BorshOutput<BorshBuffer> {
    @NonNull
    protected final ByteBuffer buffer;

    protected BorshBuffer(@NonNull ByteBuffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.mark();
    }

    protected byte[] array() {
        assert (this.buffer.hasArray());
        return this.buffer.array();
    }

    @NonNull
    public static BorshBuffer allocate(int capacity) {
        return new BorshBuffer(ByteBuffer.allocate(capacity));
    }

    @NonNull
    public static BorshBuffer allocateDirect(int capacity) {
        return new BorshBuffer(ByteBuffer.allocateDirect(capacity));
    }

    @NonNull
    public static BorshBuffer wrap(byte[] array) {
        return new BorshBuffer(ByteBuffer.wrap(array));
    }

    @NonNull
    public byte[] toByteArray() {
        assert (this.buffer.hasArray());
        int arrayOffset = this.buffer.arrayOffset();
        return Arrays.copyOfRange(this.buffer.array(), arrayOffset, arrayOffset + this.buffer.position());
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    @NonNull
    public BorshBuffer reset() {
        this.buffer.reset();
        return this;
    }

    @Override
    public short readU16() {
        return this.buffer.getShort();
    }

    @Override
    public int readU32() {
        return this.buffer.getInt();
    }

    @Override
    public long readU64() {
        return this.buffer.getLong();
    }

    @Override
    public float readF32() {
        return this.buffer.getFloat();
    }

    @Override
    public double readF64() {
        return this.buffer.getDouble();
    }

    @Override
    public byte read() {
        return this.buffer.get();
    }

    @Override
    public void read(@NonNull byte[] result, int offset, int length) {
        this.buffer.get(result, offset, length);
    }

    @Override
    @NonNull
    public BorshBuffer writeU16(short value) {
        this.buffer.putShort(value);
        return this;
    }

    @Override
    @NonNull
    public BorshBuffer writeU32(int value) {
        this.buffer.putInt(value);
        return this;
    }

    @Override
    @NonNull
    public BorshBuffer writeU64(long value) {
        this.buffer.putLong(value);
        return this;
    }

    @Override
    @NonNull
    public BorshBuffer writeF32(float value) {
        this.buffer.putFloat(value);
        return this;
    }

    @Override
    @NonNull
    public BorshBuffer writeF64(double value) {
        this.buffer.putDouble(value);
        return this;
    }

    @Override
    @NonNull
    public BorshBuffer write(@NonNull byte[] bytes) {
        this.buffer.put(bytes);
        return this;
    }

    @Override
    @NonNull
    public BorshBuffer write(byte b) {
        this.buffer.put(b);
        return this;
    }
}

