/*
 * Decompiled with CFR 0.152.
 */
package org.near.borshj;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import org.near.borshj.BorshBuffer;

public interface Borsh {
    @NonNull
    public static byte[] serialize(@NonNull Object object) {
        return ((BorshBuffer)BorshBuffer.allocate(4096).write(Objects.requireNonNull(object))).toByteArray();
    }

    @NonNull
    public static <T> T deserialize(@NonNull byte[] bytes, @NonNull Class klass) {
        return Borsh.deserialize(BorshBuffer.wrap(Objects.requireNonNull(bytes)), klass);
    }

    @NonNull
    public static <T> T deserialize(@NonNull BorshBuffer buffer, @NonNull Class klass) {
        return buffer.read(Objects.requireNonNull(klass));
    }

    public static boolean isSerializable(@Nullable Class klass) {
        if (klass == null) {
            return false;
        }
        return Arrays.stream(klass.getInterfaces()).anyMatch(iface -> iface == Borsh.class) || Borsh.isSerializable(klass.getSuperclass());
    }
}

