/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.wallet.key;

import com.portto.solana.web3.wallet.crypto.Hash;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class HdKey {
    private byte[] version;
    private int depth;
    private byte[] fingerprint;
    private byte[] childNumber;
    private byte[] chainCode;
    private byte[] keyData;

    HdKey(byte[] version, int depth, byte[] fingerprint, byte[] childNumber, byte[] chainCode, byte[] keyData) {
        this.version = version;
        this.depth = depth;
        this.fingerprint = fingerprint;
        this.childNumber = childNumber;
        this.chainCode = chainCode;
        this.keyData = keyData;
    }

    HdKey() {
    }

    public void setVersion(byte[] version) {
        this.version = version;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setFingerprint(byte[] fingerprint) {
        this.fingerprint = fingerprint;
    }

    public void setChildNumber(byte[] childNumber) {
        this.childNumber = childNumber;
    }

    public void setChainCode(byte[] chainCode) {
        this.chainCode = chainCode;
    }

    public void setKeyData(byte[] keyData) {
        this.keyData = keyData;
    }

    public byte[] getChainCode() {
        return this.chainCode;
    }

    public byte[] getKey() {
        ByteArrayOutputStream key = new ByteArrayOutputStream();
        try {
            key.write(this.version);
            key.write(new byte[]{(byte)this.depth});
            key.write(this.fingerprint);
            key.write(this.childNumber);
            key.write(this.chainCode);
            key.write(this.keyData);
            byte[] checksum = Hash.sha256Twice(key.toByteArray(), 0, key.size());
            key.write(Arrays.copyOfRange(checksum, 0, 4));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write key");
        }
        return key.toByteArray();
    }

    public int getDepth() {
        return this.depth;
    }

    public byte[] getKeyData() {
        return this.keyData;
    }

    public byte[] getVersion() {
        return this.version;
    }
}

