/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.wallet.crypto;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECPoint;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0007J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0007R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/portto/solana/web3/wallet/crypto/Secp256k1;", "", "()V", "SECP", "Lorg/bouncycastle/asn1/x9/X9ECParameters;", "kotlin.jvm.PlatformType", "getSECP", "()Lorg/bouncycastle/asn1/x9/X9ECParameters;", "n", "Ljava/math/BigInteger;", "getN$annotations", "getN", "()Ljava/math/BigInteger;", "deserP", "Lorg/bouncycastle/math/ec/ECPoint;", "p", "", "point", "serP", "web3"})
public final class Secp256k1 {
    @NotNull
    public static final Secp256k1 INSTANCE = new Secp256k1();
    private static final X9ECParameters SECP = CustomNamedCurves.getByName((String)"secp256k1");

    private Secp256k1() {
    }

    public final X9ECParameters getSECP() {
        return SECP;
    }

    @JvmStatic
    @NotNull
    public static final byte[] serP(@NotNull ECPoint p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        byte[] byArray = p.getEncoded(true);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"p.getEncoded(true)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final ECPoint deserP(@NotNull byte[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        ECPoint eCPoint = SECP.getCurve().decodePoint(p);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"SECP.curve.decodePoint(p)");
        return eCPoint;
    }

    @JvmStatic
    @NotNull
    public static final ECPoint point(@NotNull BigInteger p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        ECPoint eCPoint = SECP.getG().multiply(p);
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"SECP.g.multiply(p)");
        return eCPoint;
    }

    @NotNull
    public static final BigInteger getN() {
        BigInteger bigInteger = SECP.getN();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"SECP.n");
        return bigInteger;
    }

    @JvmStatic
    public static /* synthetic */ void getN$annotations() {
    }
}

