/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.wallet.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/portto/solana/web3/wallet/crypto/HmacSha512;", "", "()V", "HMAC_SHA512", "", "hmac512", "", "key", "seed", "web3"})
public final class HmacSha512 {
    @NotNull
    public static final HmacSha512 INSTANCE = new HmacSha512();
    @NotNull
    private static final String HMAC_SHA512 = "HmacSHA512";

    private HmacSha512() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] hmac512(@NotNull byte[] key, @NotNull byte[] seed) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        try {
            Mac sha512_HMAC = Mac.getInstance(HMAC_SHA512);
            SecretKeySpec keySpec = new SecretKeySpec(seed, HMAC_SHA512);
            sha512_HMAC.init(keySpec);
            byArray = sha512_HMAC.doFinal(key);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n            val sha512\u2026AC.doFinal(key)\n        }");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to perform hmac512.", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unable to perform hmac512.", e);
        }
        return byArray;
    }
}

