/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.wallet.crypto;

import com.portto.solana.web3.wallet.crypto.Hash;
import com.portto.solana.web3.wallet.crypto.Secp256k1;
import java.math.BigInteger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/portto/solana/web3/wallet/crypto/HdUtil;", "", "()V", "append", "", "a", "b", "getFingerprint", "keyData", "parse256", "Ljava/math/BigInteger;", "p", "reverse", "", "array", "ser256", "ser32", "i", "", "web3"})
public final class HdUtil {
    @NotNull
    public static final HdUtil INSTANCE = new HdUtil();

    private HdUtil() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] ser32(long i) {
        byte[] ser = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return ser;
    }

    @JvmStatic
    @NotNull
    public static final byte[] ser256(@NotNull BigInteger p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        byte[] byteArray = p.toByteArray();
        byte[] ret = new byte[32];
        Arrays.fill(ret, (byte)0);
        if (byteArray.length <= ret.length) {
            System.arraycopy(byteArray, 0, ret, ret.length - byteArray.length, byteArray.length);
        } else {
            System.arraycopy(byteArray, byteArray.length - ret.length, ret, 0, ret.length);
        }
        return ret;
    }

    @JvmStatic
    @NotNull
    public static final BigInteger parse256(@NotNull byte[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return new BigInteger(1, p);
    }

    public final void reverse(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int i = 0;
        int j = array.length - 1;
        byte tmp = 0;
        while (j > i) {
            tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            int n = j;
            j = n + -1;
            n = i;
            i = n + 1;
        }
    }

    @JvmStatic
    @NotNull
    public static final byte[] append(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    @JvmStatic
    @NotNull
    public static final byte[] getFingerprint(@NotNull byte[] keyData) {
        Intrinsics.checkNotNullParameter((Object)keyData, (String)"keyData");
        byte[] point = Secp256k1.serP(Secp256k1.point(HdUtil.parse256(keyData)));
        byte[] h160 = Hash.h160(point);
        byte[] byArray = new byte[]{h160[0], h160[1], h160[2], h160[3]};
        return byArray;
    }
}

