/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.wallet.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J$\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Lcom/portto/solana/web3/wallet/crypto/Hash;", "", "()V", "h160", "", "input", "sha256", "sha256Twice", "bytes", "offset", "", "length", "web3"})
public final class Hash {
    @NotNull
    public static final Hash INSTANCE = new Hash();

    private Hash() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] sha256(@NotNull byte[] input) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byArray = digest.digest(input);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n            val digest\u2026t.digest(input)\n        }");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to find SHA-256", e);
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] sha256Twice(@NotNull byte[] bytes, int offset, int length) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(bytes, offset, length);
            digest.update(digest.digest());
            byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n            val digest\u2026digest.digest()\n        }");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to find SHA-256", e);
        }
        return byArray;
    }

    public static /* synthetic */ byte[] sha256Twice$default(byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return Hash.sha256Twice(byArray, n, n2);
    }

    @JvmStatic
    @NotNull
    public static final byte[] h160(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] sha256 = Hash.sha256(input);
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }
}

