/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.wallet;

import com.portto.solana.web3.wallet.DerivableType;
import com.portto.solana.web3.wallet.HdAddress;
import com.portto.solana.web3.wallet.HdKeyGenerator;
import com.portto.solana.web3.wallet.SolanaCoin;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/portto/solana/web3/wallet/SolanaBip44;", "", "()V", "ACCOUNT", "", "CHANGE", "", "PURPOSE", "TYPE", "hdKeyGenerator", "Lcom/portto/solana/web3/wallet/HdKeyGenerator;", "solanaCoin", "Lcom/portto/solana/web3/wallet/SolanaCoin;", "getPrivateKeyFromBip44Seed", "", "seed", "getPrivateKeyFromBip44SeedWithChange", "getPrivateKeyFromSeed", "derivableType", "Lcom/portto/solana/web3/wallet/DerivableType;", "web3"})
public final class SolanaBip44 {
    @NotNull
    private final HdKeyGenerator hdKeyGenerator = new HdKeyGenerator();
    @NotNull
    private final SolanaCoin solanaCoin = new SolanaCoin();
    private final long PURPOSE = this.solanaCoin.getPurpose();
    private final long TYPE = this.solanaCoin.getCoinType();
    private final long ACCOUNT;
    private final int CHANGE;

    public SolanaBip44() {
        this.ACCOUNT = 0L;
        this.CHANGE = 0;
    }

    @NotNull
    public final byte[] getPrivateKeyFromSeed(@NotNull byte[] seed, @Nullable DerivableType derivableType) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        DerivableType derivableType2 = derivableType;
        switch (derivableType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[derivableType2.ordinal()]) {
            case 1: {
                byArray = this.getPrivateKeyFromBip44Seed(seed);
                break;
            }
            case 2: {
                byArray = this.getPrivateKeyFromBip44SeedWithChange(seed);
                break;
            }
            default: {
                throw new RuntimeException("DerivableType not supported");
            }
        }
        return byArray;
    }

    private final byte[] getPrivateKeyFromBip44SeedWithChange(byte[] seed) {
        HdAddress masterAddress = this.hdKeyGenerator.getAddressFromSeed(seed, this.solanaCoin);
        HdAddress purposeAddress = this.hdKeyGenerator.getAddress(masterAddress, this.PURPOSE, this.solanaCoin.getAlwaysHardened());
        HdAddress coinTypeAddress = this.hdKeyGenerator.getAddress(purposeAddress, this.TYPE, this.solanaCoin.getAlwaysHardened());
        HdAddress accountAddress = this.hdKeyGenerator.getAddress(coinTypeAddress, this.ACCOUNT, this.solanaCoin.getAlwaysHardened());
        HdAddress changeAddress = this.hdKeyGenerator.getAddress(accountAddress, this.CHANGE, this.solanaCoin.getAlwaysHardened());
        byte[] byArray = changeAddress.getPrivateKey().getPrivateKey();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"changeAddress.privateKey.privateKey");
        return byArray;
    }

    private final byte[] getPrivateKeyFromBip44Seed(byte[] seed) {
        HdAddress masterAddress = this.hdKeyGenerator.getAddressFromSeed(seed, this.solanaCoin);
        HdAddress purposeAddress = this.hdKeyGenerator.getAddress(masterAddress, this.PURPOSE, this.solanaCoin.getAlwaysHardened());
        HdAddress coinTypeAddress = this.hdKeyGenerator.getAddress(purposeAddress, this.TYPE, this.solanaCoin.getAlwaysHardened());
        HdAddress accountAddress = this.hdKeyGenerator.getAddress(coinTypeAddress, this.ACCOUNT, this.solanaCoin.getAlwaysHardened());
        byte[] byArray = accountAddress.getPrivateKey().getPrivateKey();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"accountAddress.privateKey.privateKey");
        return byArray;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DerivableType.values().length];
            nArray[DerivableType.BIP44.ordinal()] = 1;
            nArray[DerivableType.BIP44CHANGE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

