/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.util;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import org.bitcoinj.core.Utils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bJ \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\bH\u0007J\u0016\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/portto/solana/web3/util/ByteUtils;", "", "()V", "HEX_ARRAY", "", "getHEX_ARRAY", "()[C", "UINT_32_LENGTH", "", "UINT_64_LENGTH", "bytesToHex", "", "bytes", "", "getBit", "data", "pos", "readBytes", "buf", "offset", "length", "readUint64", "Ljava/math/BigInteger;", "readUint64Price", "trim", "uint64ToByteStreamLE", "", "val", "stream", "Ljava/io/OutputStream;", "web3"})
public final class ByteUtils {
    @NotNull
    public static final ByteUtils INSTANCE = new ByteUtils();
    public static final int UINT_32_LENGTH = 4;
    public static final int UINT_64_LENGTH = 8;
    @NotNull
    private static final char[] HEX_ARRAY;

    private ByteUtils() {
    }

    @NotNull
    public final char[] getHEX_ARRAY() {
        return HEX_ARRAY;
    }

    @JvmStatic
    @NotNull
    public static final byte[] readBytes(@NotNull byte[] buf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        byte[] b = new byte[length];
        System.arraycopy(buf, offset, b, 0, length);
        return b;
    }

    @JvmStatic
    @NotNull
    public static final BigInteger readUint64(@NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return new BigInteger(Utils.reverseBytes((byte[])ByteUtils.readBytes(buf, offset, 8)));
    }

    @NotNull
    public final BigInteger readUint64Price(@NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return new BigInteger(ByteUtils.readBytes(buf, offset, 8));
    }

    @JvmStatic
    public static final void uint64ToByteStreamLE(@NotNull BigInteger val, @NotNull OutputStream stream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        byte[] bytes = val.toByteArray();
        if (bytes.length > 8) {
            if (!((Object)bytes[0]).equals(0)) {
                throw new RuntimeException("Input too large to encode into a uint64");
            }
            byte[] byArray = bytes;
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes");
            bytes = ByteUtils.readBytes(byArray, 1, bytes.length - 1);
        }
        bytes = Utils.reverseBytes((byte[])bytes);
        stream.write(bytes);
        if (bytes.length < 8) {
            int n = 0;
            int n2 = 8 - bytes.length;
            while (n < n2) {
                int i = n++;
                stream.write(0);
            }
        }
    }

    @NotNull
    public final String bytesToHex(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        char[] hexChars = new char[bytes.length * 2];
        int n = 0;
        int n2 = bytes.length;
        while (n < n2) {
            int j = n++;
            int v = Util.and((byte)bytes[j], (int)255);
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    @NotNull
    public final byte[] trim(@NotNull byte[] bytes) {
        int i;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        for (i = bytes.length - 1; i >= 0 && ((Object)bytes[i]).equals(0); --i) {
        }
        byte[] byArray = Arrays.copyOf(bytes, i + 1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(bytes, i + 1)");
        return byArray;
    }

    public final int getBit(@NotNull byte[] data, int pos) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int posByte = pos / 8;
        int posBit = pos % 8;
        byte valByte = data[posByte];
        return valByte >> posBit & 1;
    }

    static {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        HEX_ARRAY = cArray;
    }
}

