/*
 * Decompiled with CFR 0.152.
 */
package com.portto.solana.web3.programs;

import com.portto.solana.web3.AccountMeta;
import com.portto.solana.web3.PublicKey;
import com.portto.solana.web3.TransactionInstruction;
import com.portto.solana.web3.programs.Program;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J&\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0007J6\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/portto/solana/web3/programs/TokenProgram;", "Lcom/portto/solana/web3/programs/Program;", "()V", "CLOSE_ACCOUNT_METHOD_ID", "", "INITIALIZE_METHOD_ID", "PROGRAM_ID", "Lcom/portto/solana/web3/PublicKey;", "getPROGRAM_ID", "()Lcom/portto/solana/web3/PublicKey;", "SYSVAR_RENT_PUBKEY", "getSYSVAR_RENT_PUBKEY", "TRANSFER_CHECKED_METHOD_ID", "TRANSFER_METHOD_ID", "closeAccount", "Lcom/portto/solana/web3/TransactionInstruction;", "account", "destination", "owner", "encodeTransferCheckedTokenInstructionData", "", "amount", "", "decimals", "", "encodeTransferTokenInstructionData", "initializeAccount", "mint", "transfer", "source", "transferChecked", "tokenMint", "web3"})
public final class TokenProgram
extends Program {
    @NotNull
    public static final TokenProgram INSTANCE = new TokenProgram();
    @NotNull
    private static final PublicKey PROGRAM_ID = new PublicKey("TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA");
    @NotNull
    private static final PublicKey SYSVAR_RENT_PUBKEY = new PublicKey("SysvarRent111111111111111111111111111111111");
    private static final int INITIALIZE_METHOD_ID = 1;
    private static final int TRANSFER_METHOD_ID = 3;
    private static final int CLOSE_ACCOUNT_METHOD_ID = 9;
    private static final int TRANSFER_CHECKED_METHOD_ID = 12;

    private TokenProgram() {
    }

    @NotNull
    public final PublicKey getPROGRAM_ID() {
        return PROGRAM_ID;
    }

    @NotNull
    public final PublicKey getSYSVAR_RENT_PUBKEY() {
        return SYSVAR_RENT_PUBKEY;
    }

    @NotNull
    public final TransactionInstruction transfer(@NotNull PublicKey source, @NotNull PublicKey destination, long amount, @NotNull PublicKey owner) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        List keys = new ArrayList();
        keys.add(new AccountMeta(source, false, true));
        keys.add(new AccountMeta(destination, false, true));
        keys.add(new AccountMeta(owner, true, false));
        byte[] transactionData = this.encodeTransferTokenInstructionData(amount);
        return Program.Companion.createTransactionInstruction(PROGRAM_ID, keys, transactionData);
    }

    @NotNull
    public final TransactionInstruction transferChecked(@NotNull PublicKey source, @NotNull PublicKey destination, long amount, byte decimals, @NotNull PublicKey owner, @NotNull PublicKey tokenMint) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)tokenMint, (String)"tokenMint");
        List keys = new ArrayList();
        keys.add(new AccountMeta(source, false, true));
        keys.add(new AccountMeta(tokenMint, false, false));
        keys.add(new AccountMeta(destination, false, true));
        keys.add(new AccountMeta(owner, true, false));
        byte[] transactionData = this.encodeTransferCheckedTokenInstructionData(amount, decimals);
        return Program.Companion.createTransactionInstruction(PROGRAM_ID, keys, transactionData);
    }

    @NotNull
    public final TransactionInstruction initializeAccount(@NotNull PublicKey account, @NotNull PublicKey mint, @NotNull PublicKey owner) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)mint, (String)"mint");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        List keys = new ArrayList();
        keys.add(new AccountMeta(account, false, true));
        keys.add(new AccountMeta(mint, false, false));
        keys.add(new AccountMeta(owner, false, true));
        keys.add(new AccountMeta(SYSVAR_RENT_PUBKEY, false, false));
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)1);
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
        return Program.Companion.createTransactionInstruction(PROGRAM_ID, keys, byArray);
    }

    @NotNull
    public final TransactionInstruction closeAccount(@NotNull PublicKey account, @NotNull PublicKey destination, @NotNull PublicKey owner) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        List keys = new ArrayList();
        keys.add(new AccountMeta(account, false, true));
        keys.add(new AccountMeta(destination, false, true));
        keys.add(new AccountMeta(owner, false, false));
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)9);
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
        return Program.Companion.createTransactionInstruction(PROGRAM_ID, keys, byArray);
    }

    private final byte[] encodeTransferTokenInstructionData(long amount) {
        ByteBuffer result = ByteBuffer.allocate(9);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put((byte)3);
        result.putLong(amount);
        byte[] byArray = result.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"result.array()");
        return byArray;
    }

    private final byte[] encodeTransferCheckedTokenInstructionData(long amount, byte decimals) {
        ByteBuffer result = ByteBuffer.allocate(10);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put((byte)12);
        result.putLong(amount);
        result.put(decimals);
        byte[] byArray = result.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"result.array()");
        return byArray;
    }
}

